package xmlbook.chapter12;

import java.io.*;
import java.sql.*;
import java.text.*;
import java.util.*;

import org.jdom.*;

public class RStoXML {

    private SQLException exception;

    private ResultSet rs;
    private int intColCount;
    private ResultSetMetaData rsmd;

    // kluczem jest oryginalna nazwa kolumny ustawiana na nazw zamienn
    private Map newNames = new HashMap();

    // kluczem jest oryginalna kolumna bazy danych, prawda albo fasz
    private Map attribs = new HashMap();
    int maxRows = Integer.MAX_VALUE;        // domylnie dla wszystkich
    private String rootName = "ROOT";
    private String rowName = "RECORD";


     public RStoXML(ResultSet rs) {
     this.rs = rs;
     try {
        rsmd = rs.getMetaData();
        intColCount = rsmd.getColumnCount();

      }
      catch (SQLException e) {
        // przechowanie wyjtku do momentu wywoania build()
        exception = e;
      }

     }
    public RStoXML(ResultSet rs, String rootName, String rowName) {
        this(rs);
        setRootName(rootName);
        setRowName(rowName);

    }

    public Document build() throws JDOMException {
      if (exception != null) {
        throw new JDOMException("Problem z baz danych", exception);
      }
      try {

        Element root = new Element(rootName);
        Document doc = new Document(root);

        int rowCount = 0;

        // pobranie nazw kolumn dla zbioru rekordw
        String[] columnName = new String[intColCount];
        for (int index = 0; index < intColCount; index++) {
          columnName[index] = rsmd.getColumnName(index+1);
        }

        // utworzenie org.jdom.Document ze zbioru wynikowego
        String name;
        String value;
        Element record;
        Element child;

        while (rs.next() && (rowCount++ < maxRows)) {
            record = new Element(rowName);
            for (int col = 1; col <= intColCount; col++) {
                if (newNames.isEmpty() ||
                    (newNames.get(columnName[col-1].toLowerCase()) == null))
                    name = columnName[col-1];
                else
                    name = lookupName(columnName[col-1]);
                value = rs.getString(col);
                if ( attribs.containsKey(columnName[col-1].toLowerCase())) {
                    //jeeli warto kolumny jest w attribs
                    //i nie jest null, utwrz atrybut
                    record.setAttribute(name, value);
                }
                else {
                    //w pozostaych przypadkach utwrz elementy-dzieci
                    child = new Element(name);
                    if (!rs.wasNull())
                        child.setText(value);
                    record.addContent(child);
                }
            }
            root.addContent(record);
            }

            return doc;
            }
            catch (SQLException e) {
                throw new JDOMException("Problem z baz danych", e);
            }
        }

    //origName to nazwa kolumny w bazie danych, jeeli istnieje nazwa w hashmap newNames
    //zwr j, inaczej zwr nazw przekazan
   private String lookupName(String origName) {
                  String name = (String) newNames.get(origName.toLowerCase());
                  if (name != null) {
                    return name;
                  }
                  else {
                    return origName;
                  }
    }

    // zatrzymaj to
    public void setRootName(String rootName) {
      this.rootName = rootName;
    }
    // zatrzymaj to
    public void setRowName(String rowName) {
      this.rowName = rowName;
    }

    // zatrzymaj to
    public void setMaxRows(int maxRows) {
      this.maxRows = maxRows;
    }
    // nie dziaa
    public void setAsAttribute(String columnName, String attribName) {
      String name = columnName.toLowerCase();
      attribs.put(name, "t");
      newNames.put(name, attribName);
    }
    // nie dziaa
    public void setAllAttribute() throws JDOMException{
        try{
            int intColCount = rsmd.getColumnCount();
            for (int index = 0; index < intColCount; index++) {
                attribs.put(rsmd.getColumnName(index+1).toLowerCase(), "t");
         }
        }catch (SQLException e) {
        throw new JDOMException("Problem z baz danych", e);
       }
    }
    public void setName(String columnName, String name){
        newNames.put(columnName.toLowerCase(), name);
    }
   // ustawienie nazwy kolumny bazy danych na okrelon nazw elementu
   public void setAsName(String columnName, String elemName) {
      String name = columnName.toLowerCase();
      newNames.put(name, elemName);
    }


}
