<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="Sort" />
<xsl:param name="Page" />
<xsl:output method="html" />

<xsl:template match="/">

    <table border="0" cellpadding="3">

    <!-- utworzenie waciwych czy i nagwkw zgodnie z zawartoci -->
    <xsl:if test="count(/*/*) &gt; 1">
        <tr><td colspan="100%"><a href="{$Page}">Ukryj dolegliwoci</a></td></tr>
        <xsl:call-template name="headershow"/>
    </xsl:if>
    <xsl:if test="count(/*/*) = 1">
        <a href="{$Page}?show=1">Poka dolegliwoci</a>
        <xsl:call-template name="headerhide"/>
    </xsl:if>

    <!-- iteracja przez kady rekord klienta znajdujcy si w pierwszym dziecku elementu gwnego -->
    <xsl:for-each select="*/*[1]/*" >
        <xsl:sort select="*[$Sort]" />

        <!-- przechowanie indeksu biecego rekordu klienta -->
        <xsl:variable name="index" select="RCD_index" />
        <tr bgcolor="#fffeee">

            <!-- wybranie wszystkich danych klienta oprcz indeksu do wywietlenia -->
            <xsl:for-each select = "*[position() &gt; 1]" >
                <td><xsl:value-of select = "." /></td>
            </xsl:for-each>
            <td /><td />
        </tr>

            <!-- wybranie wszyskich rekordw dolegliwoci, krych ID klienta -->
            <!-- jest taki sam, jak biecego klienta -->
            <xsl:for-each select="/*/*[2]/*[RCA_clientID = $index]">
               <xsl:sort select="RCA_medicalailment" />
               <tr bgcolor="#eeefff"><td /><td /><td /><td /><td />
                    <td ><xsl:value-of select = "RCA_medicalailment" /></td>
                    <td ><xsl:value-of select = "RCA_datefound" /></td>
                </tr>
            </xsl:for-each>
        </xsl:for-each>
    </table>

</xsl:template>

<!-- utworzenie nagwkw tabeli z nazw znacznikw -->
<xsl:template name="headershow">
<tr>
    <xsl:for-each select="*/*[1]/*[1]/*[position() &gt; 1]">
        <th>
            <A href="{$Page}?sort={position() + 1}&amp;show=1">
                <xsl:value-of select="local-name(.)" />
           </A>
        </th>
    </xsl:for-each>
    <th>Dolegliwo medyczna</th>
    <th>Data wystpienia</th>
</tr>
</xsl:template>

<xsl:template name="headerhide">
<tr>
    <xsl:for-each select="*/*[1]/*[1]/*[position() &gt; 1]">
        <th>
            <A href="{$Page}?sort={position() + 1}">
                <xsl:value-of select="local-name(.)" />
           </A>
        </th>
    </xsl:for-each>
</tr>
</xsl:template>

</xsl:stylesheet>
