<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="Sort"/>
<xsl:param name="Page"/>
<xsl:output method="html" />

<xsl:template match="/">

<table border="1">
    <xsl:call-template name="header"/>
    <xsl:apply-templates select="*/*">
        <xsl:sort select="*[$Sort]" />
    </xsl:apply-templates>
</table>

</xsl:template>

<!-- utworz naglowki tabeli z nazw znacznikow -->
<xsl:template name="header">
<tr>
    <xsl:for-each select="*/*[1]/*">
        <th>
            <A href="{$Page}?sort={position()}">
                <xsl:value-of select="local-name(.)" />
           </A>
         </th>
    </xsl:for-each>
</tr>
</xsl:template>

<!-- utworz wiersz dla kazdego dziecka elementu glownego -->
<!-- i komorke dla kazdego wnuka -->
<xsl:template match="*/*">
    <tr>
        <xsl:for-each select="*">
            <td><xsl:value-of select="." /></td>
        </xsl:for-each>
    </tr>
</xsl:template>

</xsl:stylesheet>
