<%@page import = "java.sql.*,
        org.jdom.*,
        org.jdom.output.*,
        javax.xml.transform.*,
        javax.xml.transform.stream.*,
        org.jdom.transform.*,
        xmlbook.chapter11.*" %>
<html>
<head><title>DB do XML i XSL</title></head>
<body>
<div>
<%  // 1. Pobranie parametrw z url
    int sort_by;
    try{
        sort_by = Integer.parseInt(request.getParameter("sort"));
    }catch(NumberFormatException e){
    //jeeli parametr jest niewany albo nie istnieje, sortuj wedug RCD_lname
        sort_by = 1;
    }

    // 2. Inicjalizacja innych zmiennych
    String final_status   = "";
    String db_query       = "select RCD_lname, RCD_fname, ";
           db_query       +="DATE_FORMAT(RCD_dob, '%Y-%m-%d') as RCD_dob , ";
           db_query       +="RCD_clinic, RCD_color from reportclientdata";
    String db_location    = "jdbc:mysql://localhost/xmlbook";
    String db_driver      = "org.gjt.mm.mysql.Driver";
    String stylesheet     = "CrossTab.xsl";

    // 3. Utworzenie poczenia z baz danych
    Connection db_connection = null;
    java.sql.Statement db_statement = null;
    ResultSet rs = null;
    try{
        Class.forName(db_driver);
        db_connection = DriverManager.getConnection(db_location);
        db_statement = db_connection.createStatement();

        //pobierz zbir wynikowy
        rs = db_statement.executeQuery(db_query);
    }
    catch (ClassNotFoundException e){
        final_status  = "Bd: nie mona utworzy klasy sterownika bazy danych.";
        final_status += " <br />" +  e.toString();
    }
    catch(SQLException e){
        final_status = "Bd: nie mona utworzy poczenia z baz danych";
        final_status += "albo wykona instrukcji.";
        final_status += " <br />" +  e.toString();
    }
    finally
    {  /* Naley teraz zamkn poczenie z baz danych */
        try
        {   if (db_connection != null)
            { db_connection.close(); }
        }
        catch (SQLException e)
        {   final_status  = "Bd: nie mona zamkn poczenia z baz danych.";
            final_status += " <br />" +  e.toString();
        }
    }
    try{
        // utwrz resultsetbuilder w celu przksztacenia resultset do XML
        RStoXML rsxml = new RStoXML(rs, "ROOT", "RECORD");

        //utwrz XML z recordset
        org.jdom.Document jdomdoc = rsxml.build();
        rs = null;

        //pobierz arkusz stylw
        String path = request.getServletPath();
        path = path.substring(0,path.indexOf("DBtoXML.jsp")) ;
        String  xsl  = application.getRealPath(path + stylesheet);

        //utwrz transformer
        Transformer transformer = TransformerFactory.newInstance()
                 .newTransformer(new StreamSource(xsl));
        transformer.setParameter("Sort", new Integer(sort_by));
        transformer.setParameter("Page", "DBtoXML.jsp");
        //transformer.setParameter("NFilter", new Integer(nFilter_by));
        //transformer.setParameter("CFilter", cFilter_by);

        JDOMResult jdomresults = new JDOMResult();
        transformer.transform(new JDOMSource(jdomdoc), jdomresults);
        jdomdoc = null;

        //utwrz outputter w celu wysania wynikw na wyjcie
        XMLOutputter output = new XMLOutputter("   ", true);
        //wylij wyniki na wyjcie
        Document docResults = jdomresults.getDocument();
        output.output(docResults, out);
    }
    catch (TransformerFactoryConfigurationError e) {
        final_status = "Bd: nie mona utworzy fabryki do przeksztacenia ";
        final_status = "XSL i XML.";
        final_status += "<br />" +  e.toString();
    }
    catch (TransformerException e) {
        final_status = "Bd: nie mona przetworzy XSL i XML.";
        final_status += "<br />" +  e.toString();
    }
    catch (JDOMException e)
    {   final_status  = "Bd: nie mona utworzy XML z zapytania bazy danych.";
        final_status += "<br />" +  e.toString();
    }

    if(final_status != "")
        out.print("<br><font color=\"red\"><H2>" + final_status +
            "</H2></font>");
%>

</div>
</body>
</html>
