<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="NumClinics" select="5"/>
<xsl:output method="html" />

<xsl:template match="/">
    <table border="1">

        <!-- etykiety pierwszego wiersza tabeli krzyzowej -->
        <tr><th>&#160;</th><th>Blue</th><th>Green</th><th>Orange</th>
            <th>Purple</th><th>Red</th><th>Yellow</th><th>Razem:</th>
        </tr>

        <!-- poczatek petli tworzacej cialo tabeli -->
        <xsl:call-template name="crosstab" >
            <xsl:with-param name="Clinics" select="1"/>
        </xsl:call-template>
    </table>
</xsl:template>

<xsl:template name="crosstab">
    <xsl:param name="Clinics"/>
        <tr><th><xsl:value-of select="$Clinics" /></th>
            <td><xsl:value-of select="count(*/*[RCD_color='blue' and
                                                RCD_clinic=$Clinics])" /></td>
            <td><xsl:value-of select="count(*/*[RCD_color='green' and
                                                RCD_clinic=$Clinics])" /></td>
            <td><xsl:value-of select="count(*/*[RCD_color='orange' and
                                                RCD_clinic=$Clinics])" /></td>
            <td><xsl:value-of select="count(*/*[RCD_color='purple' and
                                                RCD_clinic=$Clinics])" /></td>
            <td><xsl:value-of select="count(*/*[RCD_color='red' and
                                                RCD_clinic=$Clinics])" /></td>
            <td><xsl:value-of select="count(*/*[RCD_color='yellow' and
                                                RCD_clinic=$Clinics])" /></td>
            <td><xsl:value-of select="count(*/*[RCD_clinic=$Clinics])" /></td>
        </tr>

        <!-- kontynuacja petli, jezeli spelnione sa warunki -->
        <xsl:if test="$Clinics &lt; $NumClinics">
            <xsl:call-template name="crosstab">
                <xsl:with-param name="Clinics" select="$Clinics + 1"/>
            </xsl:call-template>
        </xsl:if>

        <!-- stopka tabeli -->
        <xsl:if test="$Clinics=$NumClinics">
            <tr><th>Razem:</th>
             <td><xsl:value-of select="count(*/*[RCD_color='blue'])" /></td>
             <td><xsl:value-of select="count(*/*[RCD_color='green'])" /></td>
             <td><xsl:value-of select="count(*/*[RCD_color='orange'])" /></td>
             <td><xsl:value-of select="count(*/*[RCD_color='purple'])" /></td>
             <td><xsl:value-of select="count(*/*[RCD_color='red'])" /></td>
             <td><xsl:value-of select="count(*/*[RCD_color='yellow'])" /></td>
             <td><xsl:value-of select="count(*/*)" /></td>
            </tr>
        </xsl:if>
</xsl:template>

</xsl:stylesheet>
