import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import org.dom4j.Document;
import org.dom4j.ProcessingInstruction;
import org.xml.sax.helpers.*;
import org.xml.sax.*;
import xmlbook.chapter10.*;

public class ProcessXML extends HttpServlet {

public void doGet(HttpServletRequest request, HttpServletResponse response)
     throws IOException, ServletException
{ // Krok 1. Otrzymanie uchwytu do obiektw systemu
  ServletContext application = this.getServletConfig().getServletContext();
  PrintWriter            out = response.getWriter();

  // Krok 2. Okrelenie nazw plikw i cieek dostpu
  String spath    = request.getServletPath();
  String file     = spath.substring(spath.lastIndexOf("/") + 1,spath.length());
  String xmlpath  = application.getRealPath(spath);
  String path     = xmlpath.substring(0,xmlpath.indexOf(file));
  // See if we have the data stashed already in app space.
  String xslpath  = (String)application.getAttribute(xmlpath);
  String errorpage= "/chapter10/XMLError.jsp";

   /* Dane przechowywane w xslpath to null, false albo nazwa pliku.
      Jeeli to nazwa pliku, to jest przypisywana do xslpath. Jeeli null,
      to sprawdzenie jeszcze nigdy nie byo wykonywane. W takim wypadku
      zostanie sprawdzone, czy plik XSL istnieje */
    if (xslpath == null)
    {  try
       {String saxparser = "org.apache.xerces.parsers.SAXParser";
        XMLReader reader = XMLReaderFactory.createXMLReader(saxparser);
        reader.setFeature("http://xml.org/sax/features/validation", false);

        //utworzenie egzemplarza specjalnej klasy programu obsugi dla tego procesu
        DetermineStyleSheet dss = new DetermineStyleSheet();

        //rejestracja klasy programu obsugi
        reader.setContentHandler(dss);

        //ustawienie zmiennej application na false jako warto domylna
        application.setAttribute(xmlpath,"false");

        //przetwarzanie dokumentu XML
        try {reader.parse(xmlpath);}
        catch(StopSaxParsing ssp)
        {/* Arkusz stylw zosta znaleziony tylko wtedy, kiedy zostanie wygenerowany
            wyjtekStopSaxParsing. W takim przypadku nastpi pobranie nazwy
            pliku i umieszczenie jej w pamici */
        Document doc = dss.getDocument();
        ProcessingInstruction pi = doc.processingInstruction("xml-stylesheet");
        xslpath = path + pi.getValue("href");
        application.setAttribute(xmlpath,xslpath);
        }
        }
        catch(Exception e)
        { application.log("Bd podczas okrelania pliku XSL " + xmlpath,e); }
    }

  //Krok 3. Sprawdzenie, ktre pliki istniej
  File xmlfile = new File(xmlpath);
  File xslfile = null;
  if (xslpath != null && xslpath.equals("false") == false)
  {xslfile = new File(xslpath);}
  if (xmlfile.exists() == false)
  { // dany plik XML nie istnieje, co zostanie przekazane uytkownikowi
    request.setAttribute("XMLPage",file);
    application.getRequestDispatcher(errorpage).forward(request, response);
    return;
  }

  if (xslfile == null || xslfile.exists() == false)
  { String jsppage  = spath.substring(0,spath.lastIndexOf(".xml")) + ".jsp";
    File jspfile    = new File(application.getRealPath(jsppage));
      if (jspfile.exists() == true)
      {application.getRequestDispatcher(jsppage).forward(request, response);
       return;
      }
      else
      {request.setAttribute("XMLPage",file);
       application.getRequestDispatcher(errorpage).forward(request, response);
       return;
      }
  }
  else
  {   // Zastosowanie arkusza stylw, jeeli istnieje
      response.setContentType("text/html");
      try
      {    StreamSource xml    = new StreamSource(xmlfile);
           StreamSource xsl    = new StreamSource(xslfile);
           StreamResult result = new StreamResult(out);

           TransformerFactory tFactory = TransformerFactory.newInstance();
           Transformer transformer     = tFactory.newTransformer(xsl);
           transformer.transform(xml, result);
      }
      catch(Exception e)
      {   application.log("Bd podczas przeksztacania pliku XML:" + xmlpath,e);
          out.print(" Zasb XML jest niedostpny ");
      }
      out.close();
  }
}

}
