package xmlbook.chapter8;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import javax.servlet.ServletContext;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.Constants;

public class ProduceBanner implements java.io.Serializable 
{   private String[] banners = null;
    private int bannercount  = 0;

    public ProduceBanner() {}

    private void gatherBanners(SOAPContext a_soapcontext)
    {   if (banners == null)
        {   HttpServlet servlet = (HttpServlet)
            a_soapcontext.getProperty(Constants.BAG_HTTPSERVLET );

            ServletContext application = servlet.getServletContext();

            banners     = (String[]) application.getAttribute( "Banners");
            bannercount = banners.length;
        } 
    }

    private String randomChoice ()
    {   int li_row = (int) (Math.random() * bannercount);
        if (bannercount == 0)
            return "Niepomylna inicjalizacja bannerw. Brak bannerw w systemie";
        return banners[li_row];
    }

    public String getBanner (SOAPContext a_soapcontext, boolean ab_order)
    {   gatherBanners(a_soapcontext);
        if (bannercount == 0)
            return "Niepomylna inicjalizacja bannerw. Brak bannerw w systemie";
        if (ab_order)
        {   HttpSession session = (HttpSession)
                        a_soapcontext.getProperty(Constants.BAG_HTTPSESSION);

            Integer lastbanner = (Integer) session.getAttribute("LastBanner");
            int currentbanner = 0;
            if (lastbanner != null)
            { currentbanner = lastbanner.intValue() +1;}
            if ( currentbanner + 1 > bannercount) currentbanner = 0;

            String ls_return = "Banner numer: " + currentbanner + "<br>";
            session.setAttribute("LastBanner",new Integer(currentbanner)) ;
            return (ls_return + banners[currentbanner]);
        }
        else
        { return randomChoice();} 
    }

    public String randomBanner (SOAPContext a_soapcontext)
    { String ls_return = "";
      gatherBanners(a_soapcontext);
      return randomChoice();
    }
}
