package xmlbook.chapter7;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ProduceListing
{   public ProduceListing() {}

    public void listContent(String    as_site,
                            String    as_file,
                            String    as_path,
                            JspWriter out) throws JDOMException, IOException
    { try
      { // uyj SAX do wczytania pliku, uywa budowniczego zdefiniowanego w JAXP
        SAXBuilder builder = new SAXBuilder();

        // utwrz JDOM Document
        Document doc = builder.build(new File(as_path + "/" + as_file));

        // pobierz element gwny
        Element root = doc.getRootElement();

       // stwrz tablic z list wszystkich pozycji
       out.print("<table><tr>");
       out.print("<td align=\"center\" valign=\"bottom\" class=\"GreenBox\">");
       out.print("<a href=\"" + as_site + as_file + "\"/>");
       out.print(root.getChild("title").getTextTrim());
       out.print("</a></td></tr><tr>");
       out.print("<td align=\"left\" valign=\"top\" class=\"OffWhiteBox\">");
       out.print("<ul>");

       /* zbierz wszystkie cza i przesortuj je we waciwej kolejnoci */
       List buzzlinks = root.getChildren("buzzlink");
       int  li_count = buzzlinks.size();
       String[] news_links    = new String[li_count];
       String[] general_links = new String[li_count];
       String[] product_links = new String[li_count];

       Iterator i = buzzlinks.iterator();

       while (i.hasNext())
       {   Element link = (Element) i.next();
           if (link.getAttributeValue("type").equals("news"))
           {int position =Integer.parseInt(link.getAttributeValue("position"));
            news_links[position] = link.getChild("title").getTextTrim();
           }
           if (link.getAttributeValue("type").equals("link"))
           {int position =Integer.parseInt(link.getAttributeValue("position"));
            general_links[position] = link.getChild("title").getTextTrim();
           }
           if (link.getAttributeValue("type").equals("product"))
           {int position =Integer.parseInt(link.getAttributeValue("position"));
            product_links[position] = link.getChild("title").getTextTrim();
           }
       }

        /* najpierw wywietl wiadomoci */
        for (int loop = 0; loop < li_count; loop++)
        { if (news_links[loop] != null)
          out.print("<li>" + news_links[loop] +"</li>");
        }

        /* Nastpnie cza Ramble */
        List buzztopics = root.getChildren("ramble");
        i = buzztopics.iterator();
        while (i.hasNext())
        {   Element link = (Element) i.next();
            out.print("<li>" + link.getChild("title").getTextTrim() +"</li>");
        }

        /* Potem wydrukuj pozycje Links */
        for (int loop = 0; loop < li_count; loop++)
        { if (general_links[loop] != null)
          out.print("<li>" + general_links[loop] +"</li>");
        }

        /* Teraz wydrukuj produkty */
        for (int loop = 0; loop < li_count; loop++)
        { if (product_links[loop]!= null)
          out.print("<li>" + product_links[loop] +"</li>");
        }

        /* Nastpnie lista czy do gwnych tematw */
        buzztopics = root.getChildren("topic");
        i = buzztopics.iterator();
        while (i.hasNext())
        {   Element link = (Element) i.next();
            out.print("<li>" + link.getChild("title").getTextTrim() +"</li>");
        }

        out.print("</ul></td></tr></table>");
        }
        catch(Exception e)
        {   /* nic nie wywietlaj, jeeli co pjdzie le */
            //out.print(e.toString());
            out.print("Ta archiwalna kopia JSPBuzz jest niedostpna.");
        }
    }
}
