package xmlbook.chapter7;

import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.*;

import java.io.*;
import javax.servlet.jsp.JspWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.*;

public class ProcessDom4J
{
public ProcessDom4J() {}

public void produceXML (JspWriter out, Document a_xmlresult) throws Exception
{   try
    {   OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter( out, format );
        writer.write(a_xmlresult);
        writer.close();
    }
    catch (Exception e)
    {  throw e; }
}

public void applyXSL (JspWriter out,    Document a_xmlresult,
                      String    as_xsl) throws Exception
{       StreamSource xsl    = new StreamSource(new File(as_xsl));
        StreamResult result = new StreamResult(out);

        Transformer transformer;

        TransformerFactory factory = TransformerFactory.newInstance();

        transformer = factory.newTransformer( xsl );

        // Tworzenie rda JAXP z dokumentu dom4j
        DocumentSource source = new DocumentSource( a_xmlresult );

        // tworzenie strumienia wyciowego z poczenia xsl/dokument
        transformer.transform(source, result);
}
}
