package xmlbook.chapter7;
import java.io.File;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DatabaseParameter extends Object implements java.io.Serializable {

    private String databaseName = "";
    private String driver       = "";
    private String url          = "";
    private String userName     = "";
    private String password     = "";

    public DatabaseParameter() {}

    public DatabaseParameter(String as_db,   String as_driver, String as_url,
                             String as_name, String as_password)
    {setDatabaseName(as_db) ;
     setDriver      (as_driver) ;
     setUrl         (as_url) ;
     setUserName    (as_name);
     setPassword    (as_password);
    }

    public DatabaseParameter(String as_xmlfile) throws Exception
    {   try
        {   SAXReader xmlReader = new SAXReader();
            Document  doc       = xmlReader.read(new File(as_xmlfile));

            Element root = doc.getRootElement();

            setDatabaseName ( root.element("databasename").getText());
            setDriver       ( root.element("driver").getText());
            setUrl          ( root.element("url").getText());
            setUserName     ( root.element("username").getText());
            setPassword     ( root.element("password").getText());
        }
        catch(Exception e)
        {throw e;}
    }

    public String getDatabaseName ()  {   return databaseName;   }

    public String getDriver ()        {   return driver;   }

    public String getUrl ()           {   return url;   }

    public String getUserName ()      {   return userName;   }

    public String getPassword ()      {   return password;   }

    public void setDatabaseName (String as_data)  {databaseName = as_data; }

    public void setDriver (String as_data)        {driver = as_data; }

    public void setUrl (String as_data)           {url = as_data;}

    public void setUserName (String as_data)      {userName = as_data; }

    public void setPassword (String as_data)      {password = as_data;}
}
