package xmlbook.chapter7;

import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class BannerAdStore  implements java.io.Serializable
{
private  Document bannerData = null;

public void setBannerData(Document data) {bannerData = data;}

public Document getBannerData() {return bannerData;}

public BannerAdStore() {}

public BannerAdStore(Document data) {setBannerData(data);}

public BannerAdStore(DatabaseParameter dbdata)
{   XMLFromResult result= new XMLFromResult("BANNERS","BANNERAD");
    try
    {  String ls_sql = "select name as NAME," +
                       "       link as LINK," +
                       "       linktext as LINKTEXT," +
                       "       starttext as STARTTEXT," +
                       "       endtext as ENDTEXT" +
                       "       from bannerads";
       setBannerData(result.createXML (dbdata, ls_sql,true));
    }
    catch(Exception e)
    {  setBannerData(null);
    }
}

public String randomBannerLink()
{ int li_row = 1 + (int) (Math.random() * getCount());
  return produceBannerLink(li_row) ;
}

public String produceBannerLink (int bannerid)
{    String xpath = "//BANNERAD[" + bannerid + "]";
     Node bannernode  = bannerData.selectSingleNode( xpath );

     String link      = bannernode.valueOf( "LINK" );
     String linktext  = bannernode.valueOf( "LINKTEXT" );
     String start     = bannernode.valueOf( "STARTTEXT" );
     String end       = bannernode.valueOf( "ENDTEXT" );

     String ls_banner = " <a href=\"" + link + "\">" + linktext + "</a> ";
     return start + ls_banner + end;
}

public int getCount ()
{    Element root = bannerData.getRootElement();
     String ls_count = root.element("metadata").element("rowcount").getText();
     return Integer.parseInt(ls_count.trim());
}

public String[] bannerArray ()
{   String links[] = new String[getCount()];

    Element root = bannerData.getRootElement();
    Iterator banner_iterator = root.elementIterator("BANNERAD");
    int li_count = 0;
    while(banner_iterator.hasNext())
    {
       Element bannerad = (Element)banner_iterator.next();

       String link      = bannerad.element("LINK").getText();
       String linktext  = bannerad.element("LINKTEXT").getText();
       String start     = bannerad.element("STARTTEXT").getText();
       String end       = bannerad.element("ENDTEXT").getText();

       String banner = " <a href=\"" + link + "\">" + linktext + "</a> ";
       links[li_count]  = start + banner + end;
       li_count++;
    }
    return links;

}
}
