package xmlbook.chapter14;

import java.net.URL;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.soap.*;
import org.apache.soap.rpc.*;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.Namespace;

public class BuzzServiceCall extends Object
{
public BuzzServiceCall() {}

private String serviceserver = "";
private String objecturi     = "";

public  BuzzServiceCall(String as_url) throws Exception
{ try
  { SAXBuilder builder = new SAXBuilder();
    Document   doc     = builder.build(new URL(as_url));
    Element    root    = doc.getRootElement();
    Namespace  nsr     = root.getNamespace();
    Namespace  ns_soap = root.getNamespace("soap");

    serviceserver = root.getChild("service",nsr)
                        .getChild("port",nsr)
                        .getChild("address",ns_soap)
                        .getAttribute("location").getValue();

    objecturi =  root.getChild("binding",nsr)
                     .getChild("operation",nsr)
                     .getChild("operation",ns_soap)
                     .getAttribute("soapAction").getValue();
  }
  catch(Exception e){throw e;};
}

private String performCall(Call call) throws Exception
    {   String ls_result = "";
        try
        {   Response resp = call.invoke (new URL (serviceserver), "");
            if (resp.generatedFault())
            {Fault fault=resp.getFault();
             ls_result = " Fault code: " + fault.getFaultCode();
             ls_result = " Fault Description: " +fault.getFaultString();
             throw new Exception(ls_result);
            }
            else
            {Parameter result = resp.getReturnValue();
             ls_result  = result.getValue().toString();
            }
        }
        catch(Exception e){throw e;}

        return ls_result;
    }

public String getBuzz()
    {   String ls_result  = "";
        Call call = new Call();
        call.setTargetObjectURI(objecturi);
        call.setMethodName ("currentList");
        call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
        try{ ls_result = performCall(call);}
        catch(Exception e)
        {ls_result = e.toString();}
        return ls_result;
    }
}
