<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:param name="Sort"/>
<xsl:param name="Page"/>
<xsl:param name="PageNum"/>
<xsl:param name="Total" />
<xsl:output method="html" />

<xsl:template match="/">
    <table border="1">

        <xsl:call-template name="header"/>

        <!-- wybranie i sformatowanie kadego rekordu -->
        <xsl:apply-templates select="*/*">
            <xsl:sort select="*[$Sort]" />
        </xsl:apply-templates>
    </table>
</xsl:template>

<!-- utworzenie wszystkich nagwkw tabeli, 5 wierszy -->
<xsl:template name="header">
    <!-- tutaj s tworzone cza do poprzedniej i nastpnej strony -->
    <tr bgColor="#fffeee">
    <xsl:choose>
        <!-- jeeli strona jest pierwsza, nie pokazuj cza "poprzednia strona" -->
        <xsl:when test="$PageNum = 1">
            <th colspan="2">Pierwsza strona</th>
            <th> Strona <xsl:value-of select="$PageNum" /></th>
            <th colspan="2"><a href="{$Page}?pagenum={$PageNum + number(1)}">
                Nastpna strona</a></th>
        </xsl:when>
        <!-- jeeli strona jest ostania, nie pokazuj cza "nastpna strona" -->
        <xsl:when test="$PageNum = $Total">
            <th colspan="2"><a href="{$Page}?pagenum={$PageNum - number(1)}">
                Poprzednia strona</a></th>
            <th> Strona <xsl:value-of select="$PageNum" /></th>
            <th colspan="2">Ostatnia strona</th>
        </xsl:when>
        <!-- w pozostaych przypadkach poka oba cza -->
        <xsl:otherwise>
            <th colspan="2"><a href="{$Page}?pagenum={$PageNum - number(1)}">
                Poprzednia strona</a></th>
            <th> Strona <xsl:value-of select="$PageNum" /></th>
            <th colspan="2"><a href="{$Page}?pagenum={$PageNum + number(1)}">
                Nastpna strona</a></th>
        </xsl:otherwise>
    </xsl:choose>
    </tr>
    <tr bgColor="#eeefff"><td colspan="5">&#160;</td></tr>

    <!-- utworzenie cza numeru strony dla kadej moliwej strony raportu -->
    <tr bgColor="#fffeee">
        <td align="left" colspan="5">
            <xsl:call-template name="PageLinks">
                <xsl:with-param name="Cnt" select="1"/>
            </xsl:call-template>
        </td>
    </tr>
    <tr bgColor="#eeefff"><td colspan="5">&#160;</td></tr>

    <!-- utworzenie kadej poczonej etykiety kolumny -->
    <tr bgColor="#fffeee">
        <xsl:for-each select="*/*[1]/*">
            <td>
                <A href="{$Page}?pagenum={$PageNum}&amp;sort={position()}">
                    &#160;&#160;
                    <xsl:value-of select="local-name(.)" />
                    &#160;&#160;
                </A>
            </td>
        </xsl:for-each>
    </tr>
</xsl:template>

<!-- rekursywne tworzenie numeru poczonej strony -->
<xsl:template name="PageLinks">
    <xsl:param name="Cnt"/>
    <xsl:if test="$Cnt = $PageNum" >
        <xsl:value-of select="$Cnt" />&#160;&#160;
    </xsl:if>
    <xsl:if test="$Cnt != $PageNum" >
        <a href="{$Page}?pagenum={$Cnt}">
            <xsl:value-of select="$Cnt" />
        </a>&#160;&#160;
    </xsl:if>

    <xsl:if test="$Cnt &lt; $Total">
        <xsl:call-template name="PageLinks">
            <xsl:with-param name="Cnt" select="$Cnt + 1"/>
        </xsl:call-template>
    </xsl:if>
</xsl:template>

<!-- utworzenie wiersza tabeli dla kadego rekordu oraz komrki dla kadej kolumny -->
<xsl:template match="*/*">
    <tr bgColor="#eeefff">
        <xsl:for-each select="*">
            <td><xsl:value-of select="." /></td>
        </xsl:for-each>
    </tr>
</xsl:template>

</xsl:stylesheet>
