<%@page import = "java.sql.*,
        org.jdom.*,
        org.jdom.output.*,
        org.jdom.input.*,
        java.io.*,
        javax.xml.transform.*,
        javax.xml.transform.stream.*,
        org.jdom.transform.*,
        xmlbook.chapter11.*" %>
<html>
<head><title>Jeden do wielu</title></head>
<body>
<div>
<%  // 1. pobranie parametrw z url

    String show = request.getParameter("show");
    show = (show) != null ? "1" : "0";
    int sort_by;
    try{

        sort_by = Integer.parseInt(request.getParameter("sort"));
    }catch(NumberFormatException e){
        //jeeli parametr jest niewany lub nie istnieje, sortuj wedug RCD_lname
        sort_by = 2;
    }

    // 2. Inicjalizacja innych zmiennych
    String final_status   = "";
    String db_query       = "select * from reportclientdata ";
    String db_query2      = "select * from reportclientailments";
    String db_location    = "jdbc:mysql://localhost/xmlbook";
    String db_driver      = "org.gjt.mm.mysql.Driver";
    String stylesheet     = "OneMany.xsl";

    // 3. Utworzenie poczenia z baz danych
    Connection db_connection = null;
    Statement db_statement = null;
    ResultSet rs = null;
    Statement db_statement2 =  null;
    ResultSet rs2 = null;

    try{
        Class.forName(db_driver);
        db_connection = DriverManager.getConnection(db_location);
        db_statement = db_connection.createStatement();
        rs = db_statement.executeQuery(db_query);
        if (show != "0"){
            db_statement2 = db_connection.createStatement();
            rs2 = db_statement2.executeQuery(db_query2);
        }
    }
    catch (ClassNotFoundException e){
        final_status  = "Bd: nie mona utworzy klasy sterownika bazy danych.";
        final_status += " <br />" +  e.toString();
    }
    catch(SQLException e){
        final_status = "Bd: nie mona utworzy poczenia z baz danych";
        final_status += "albo wykona instrukcji.";
        final_status += " <br />" +  e.toString();
    }
    finally
    {  /* Naley teraz zamkn poczenie z baz danych */
        try
        {   if (db_connection != null)
            { db_connection.close(); }
        }
        catch (SQLException e)
        {   final_status  = "Bd: nie mona zamkn poczenia z baz danych.";
            final_status += " <br />" +  e.toString();
        }
    }
    try{
        // utwrz resultsetbuilder w celu przeksztacenia resultset do XML
        RStoXML rsxml = new RStoXML(rs, "RS1", "REC1");
        Document jdomdoc = rsxml.build();
        Document jdomdoc2 = null;
        if (show != "0"){
            RStoXML rsxml2 = new RStoXML(rs2, "RS2", "REC2");
            jdomdoc2 = rsxml2.build();
            rs2 = null;
            rsxml2 = null;
        }
        rs = null;
        rsxml = null;

        // pobierz arkusz stylw
        String path = request.getServletPath();
        path = path.substring(0,path.indexOf("OneMany.jsp")) ;
        String  xsl  = application.getRealPath(path + stylesheet);

        Element rootElement = new Element("ROOT");
        Document resultdoc = new Document(rootElement);
        rootElement.addContent(jdomdoc.getRootElement().detach());
        if (show != "0")
            rootElement.addContent(jdomdoc2.getRootElement().detach());

        jdomdoc2 = null;
        jdomdoc = null;

        // utwrz transformer
        Transformer transformer = TransformerFactory.newInstance()
                 .newTransformer(new StreamSource(xsl));
        transformer.setParameter("Sort", new Integer(sort_by));
        transformer.setParameter("Page", "OneMany.jsp");
        transformer.setParameter("Show", show);

        JDOMResult jdomresults = new JDOMResult();
        transformer.transform(new JDOMSource(resultdoc), jdomresults);
        resultdoc = null;
        // utwrz outputter w celu wysania wynikw na wyjcie
        XMLOutputter output = new XMLOutputter("   ", true);
        // wylij wyniki na wyjcie
        Document docResults = jdomresults.getDocument();
        output.output(docResults, out);
    }
    catch (TransformerFactoryConfigurationError e) {
        final_status = "Bd: nie mona utworzy fabryki do przeksztacenia ";
        final_status = "XSL i XML.";
        final_status += "<br />" +  e.toString();
    }
    catch (TransformerException e) {
        final_status = "Bd: nie mona przetworzy XSL i XML.";
        final_status += "<br />" +  e.toString();
   }
   catch (JDOMException e)
    {   final_status  = "Bd: nie mona utworzy XML z zapytania bazy danych.";
        final_status += "<br />" +  e.toString();
    }

    if(final_status != "")
        out.print("<br><font color=\"red\"><H2>" + final_status +
            "</H2></font>");
%>

</div>
</body>
</html>
