<?xml version="1.0" encoding="ISO-8859-2"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#xA0;">]>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="html"/>
<xsl:template match="/">
<html>
      <head><title>JSP Insider - XML do HTML - strona testowa</title>
      <style>
      .10ptBold { font-size:10pt; font-weight:bold; font-family:arial;}
      .12ptBold { font-size:12pt; font-weight:bold; font-family:arial;}
       td {font-family: verdana, Arial; font-size: 10pt; border-style: groove;
           border-width:2px; border-color:#ffffff; padding:2px;}
      .Clear {background: #ffffff; border-width:0px; padding-left:0px;
                                                     padding-right:0px;}
      .LightGreyBox {background: #eeeeee;}
      .LightGrey {background: #eeeeee; border-width:0px;}
      .OffWhite {background: #f5f5f5; border-width:0px;}
      .OffWhiteBox {background: #f5f5f5;}
      .GreenBox {background: #aabbbb;}
      </style></head>
      <body>
        <table cellspacing="0" width="100%">
            <tr><td class="OffWhite">
                <p class="12ptBold" align="center">
                JSP Buzz: wydanie #<xsl:value-of select="jspbuzz/@issue"/>
                </p>
                <p align="center" class="12ptBold">
                        <xsl:value-of select="jspbuzz/title"/>
                </p>
                <p align="center"><xsl:value-of select="jspbuzz/buzzdate"/>
                </p>
            </td></tr>
            <tr><td class="GreenBox">
                <div class="12ptBold">Spis treci</div>
            </td></tr>
            <tr><td class="OffWhiteBox">
                <div class="10ptBold"><a href="#links">Ciekawe cza</a>
                </div>
                <ol>
                <xsl:apply-templates select="jspbuzz/buzzlink[@type='link']"
                                     mode="contents">
                        <xsl:sort data-type="number" select="@position"/>
                </xsl:apply-templates>
                </ol>
            </td></tr>
            <tr><td class="GreenBox">
                <div class="12ptBold"><a name="links"/>cza</div>
            </td></tr>
            <tr><td class="WhiteBox">
                <table border="0" width="90%">
                <xsl:apply-templates select="jspbuzz/buzzlink[@type='link']">
                        <xsl:sort data-type="number" select="@position"/>
                </xsl:apply-templates>
                </table>
            </td></tr>
        </table>
        </body>
</html>
</xsl:template>

<xsl:template match="jspbuzz/buzzlink" mode="contents">
     <li><a href="#{@type}{@position}"><xsl:value-of select="title"/></a></li>
</xsl:template>

<xsl:template match="jspbuzz/buzzlink">
        <tr><td class="LightGreyBox"  width="100%">
        <a href="{link}"
         name="{@type}{@position}" target="_window" style="font-weight:bold;">
                <xsl:value-of select="title"/>
        </a>
        </td></tr>
        <xsl:if test="string-length(author)>0 or string-length(date)>0  ">
        <tr><td  class="LightGreyBox">
                <table><tr>
                <td class="LightGrey" nowrap="nowrap" width="400px">
                        <xsl:value-of select="author"/>&nbsp;</td>
                <td class="LightGrey">
                        <xsl:value-of select="date"/>&#xA0;</td>
                </tr></table>
        </td></tr>
        </xsl:if>
        <xsl:apply-templates select="body" />

</xsl:template>

<xsl:template match="body" >
      <tr><td class="Clear" valign="top" ><xsl:value-of select="."/></td></tr>
</xsl:template>

</xsl:stylesheet>