<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#xA0;">]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="html"/>

<xsl:template match="/">
    <table border="0" width="90%">
        <xsl:apply-templates select="jspbuzz/buzzlink">
                <xsl:sort data-type="number" select="@type"/>
        </xsl:apply-templates>
    </table>
</xsl:template>

<xsl:template match="jspbuzz/buzzlink">
    <tr><td width="100%">
    <a href="{link}"
       name="{@type}{@position}" target="_window" style="font-weight:bold;">
            <xsl:value-of select="title"/>
    </a>
    </td></tr>
    <xsl:if test="string-length(author)>0 or string-length(date)>0  ">
    <tr><td >
        <table><tr>
        <td nowrap="nowrap" width="400px">
             <xsl:value-of select="author"/>&#xA0;</td>
        <td> <xsl:value-of select="date"/>&#xA0;  </td>
        </tr></table>
    </td></tr>
    </xsl:if>
<xsl:apply-templates select="body" />
</xsl:template>

<xsl:template match="body" >
        <tr><td valign="top" ><xsl:value-of select="."/></td></tr>
</xsl:template>
</xsl:stylesheet>
