import java.applet.Applet;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import xmlbook.chapter8.BannerService;

public class BannerApplet extends Applet implements ActionListener {

    private List      bannerlist     = new List(5,true);
    private TextField currentbanner  = new TextField(50);
    private Button    clear          = new Button("Zeruj");
    private Button    newbanner      = new Button("Nowy");

    private BannerService banner = new BannerService();

    public void init()
    {   GridBagLayout gridbag   = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints gbc  = new GridBagConstraints();
        gbc.gridy = 0;

        gbc.gridx = 0;
        gridbag.setConstraints(newbanner, gbc);
        add(newbanner);

        gbc.gridx = 1;
        gridbag.setConstraints(clear, gbc);
        add(clear);

        gbc.gridx = 2;
        gbc.gridwidth  = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(currentbanner, gbc);
        currentbanner.setEditable(false);
        add(currentbanner);

        gbc.gridy   = 1;
        gbc.gridx   = 0;
        gbc.fill    = GridBagConstraints.BOTH;
        gridbag.setConstraints(bannerlist, gbc);
        add(bannerlist);

        clear.addActionListener(this);
        newbanner.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e)
    {   String action = e.getActionCommand();

        if(action == "Nowy")
        { updateCurrentBanner();}
        if(action == "Zeruj")
        { ClearAll(); }
    }

    public String getBanner()
    {   try
        { return banner.getRandomBanner(); }
        catch (Exception e)
        { return ("Bd pobierania bannera");}
    }

    public void updateCurrentBanner()
    {   String servicebanner = getBanner();
        currentbanner.setText(servicebanner);
        bannerlist.add(servicebanner);
    }

    public void inputNewBanner(String data)
    {   currentbanner.setText(data);
        bannerlist.add(data);
    }

    public void ClearAll()
    {     bannerlist.removeAll();
          currentbanner.setText("");
    }
}
