package xmlbook.chapter7;

import java.sql.*;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.util.NonLazyDocumentFactory;
import org.dom4j.Element;

public class XMLFromResult
{   public XMLFromResult() {}

    private String rootName = "Statement";

    private String rowName  = "row";

    public String getRootName ()      {   return rootName;   }

    public String getRowName  ()      {   return rowName;    }

    public void setRootName (String as_data)  {rootName = as_data; }

    public void setRowName  (String as_data)  {rowName = as_data;  }

    public XMLFromResult(String as_root, String as_row)
    { setRootName (as_root);
      setRowName  (as_row);
    }

    public Document createXML (DatabaseParameter dbdata, String as_query)
    throws Exception
    {   return createXML ( dbdata, as_query, false);  }

    public Document createXML (DatabaseParameter    dbdata,
                               String               as_query,
                               boolean              ab_embedmetadata)
    throws Exception
    {   String ls_dburl     = dbdata.getUrl();
        String ls_dbdriver  = dbdata.getDriver();
        Connection dbconn   = null;
        Document   resultxml= null;
        try
        {   Class.forName(ls_dbdriver);
            dbconn = DriverManager.getConnection(ls_dburl);

            Statement statement = dbconn.createStatement();

            if (statement.execute(as_query))
            {   ResultSet  results   = statement.getResultSet();
                resultxml =  CreateDocument(results,ab_embedmetadata);
            }
        }
        catch (ClassNotFoundException e)
        {   throw e;  }
        catch (SQLException e)
        {   throw e;  }
        finally
        {   try
            {   if (dbconn != null)
                { dbconn.close(); }
            }
            catch (SQLException e)
            {   throw e;  }
        }

       return resultxml;
    }

    public Document CreateDocument(ResultSet a_result)
    { return CreateDocument(a_result, false);  }

    public Document CreateDocument(ResultSet a_result,boolean ab_embedmetadata)
    {DocumentFactory factory  = NonLazyDocumentFactory.getInstance();
     Document xmldoc          = factory.createDocument();

     Element root = xmldoc.addElement(getRootName());

        if(a_result != null )
        {   try
            {
             ResultSetMetaData  metadata  = a_result.getMetaData();
             int li_columns = metadata.getColumnCount();
             int li_rows    = 0;
                while(a_result.next())
                {   li_rows++;

                     Element row = root.addElement( getRowName())
                    .addAttribute( "rownum", String.valueOf(li_rows));

                    for ( int i = 1; i <= li_columns; i++)
                    {   if(a_result.getObject(i) == null)
                        {row.addElement( metadata.getColumnLabel(i) )
                            .addText("");
                        }
                        else
                        {row.addElement( metadata.getColumnLabel(i) )
                            .addText( a_result.getObject(i).toString() );
                        }
                    }
                }
             /* osad metadane jeeli s wymagane */
             if (ab_embedmetadata)
             { Element mrow = root.addElement("metadata");
               /* osad liczb wierszy */
               mrow.addElement( "rowcount" )
                      .addText( String.valueOf(li_rows) );
               /* osad typy danych kolumn */
               for ( int i = 1; i <= li_columns; i++)
               {    mrow.addElement(metadata.getColumnLabel(i))
                           .addText(metadata.getColumnTypeName(i));
               }
             }
            }
            catch(Exception e)
            { root.addElement( "bd" ).addText(e.toString());  }
       }
    return xmldoc;
    }
}

