/*
 * @(#) $Id: BankClientShell.java,v 1.1.1.1 2003/10/05 18:39:18 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.example.bank.client;

import java.io.InputStreamReader;
import java.io.BufferedReader;
import org.jstk.example.bank.server.*;
import org.jstk.example.bank.*;

public class BankClientShell {
    public static void main(String[] args) throws Exception {
		BankClient bc = new BankClient();
		DefaultBankPersistenceManager bpm =
			new DefaultBankPersistenceManager(System.getProperties());
		BankIntf bank = bpm.load();
		bc.init(bank);
		while (true){
			System.out.print("bcsh>");
			System.out.flush();
			String cmdline = new BufferedReader(new InputStreamReader(System.in)).readLine();
			String[] cmdargs = cmdline.split("\\s");

			String result = bc.execCommand(cmdargs);
			System.out.println(result);
		}
	}
}