package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.BankIntf;
import common.RemoteBank;
import common.RemoteAccount;
import common.RemoteIterator;
import javax.security.auth.Subject;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;

public class RemoteBankImpl extends UnicastRemoteObject implements RemoteBank {
	private BankIntf bi;
	private Subject sub;

	public RemoteBankImpl(BankIntf bi, Subject sub) throws RemoteException {
		this.bi = bi;
		this.sub = sub;
	}
	public RemoteAccount openAccount(BigDecimal initialDeposit) throws RemoteException {
		final BigDecimal iDf = initialDeposit;
		final BankIntf bif = bi;
		final Subject subf = sub;
		RemoteAccount rA = null;
		try {
			rA = (RemoteAccount)Subject.doAs(sub, new PrivilegedExceptionAction() {
				public Object run() throws Exception {
					return new RemoteAccountImpl(bif.openAccount(iDf), subf);
				}
			});
		} catch (PrivilegedActionException pae){
			if (pae.getException() instanceof RemoteException)
				throw (RemoteException)pae.getException();
		}
		return rA;
	}
	public void closeAccount(String acctNo) throws Exceptions.AccountNotFound,
			Exceptions.AccountClosed, RemoteException {
		bi.closeAccount(acctNo);
	}
	public RemoteAccount getAccount(String acctNo) throws Exceptions.AccountNotFound, RemoteException {
		final String acctNof = acctNo;
		final BankIntf bif = bi;
		final Subject subf = sub;
		RemoteAccount rA = null;
		try {
			rA = (RemoteAccount)Subject.doAs(sub, new PrivilegedExceptionAction() {
				public Object run() throws Exception{
					return new RemoteAccountImpl(bif.getAccount(acctNof), subf);
				}
			});
		} catch (PrivilegedActionException pae){
			if (pae.getException() instanceof Exceptions.AccountNotFound)
				throw (Exceptions.AccountNotFound)pae.getException();
		}
		return rA;
	}
	public RemoteIterator accounts() throws RemoteException {
		return new RemoteIteratorImpl(bi);
	}
}
