package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.AccountIntf;

public class RemoteAccountImpl extends UnicastRemoteObject implements common.RemoteAccount {
	private AccountIntf acct = null;

	public RemoteAccountImpl(AccountIntf acct) throws RemoteException {
		this.acct = acct;
	}
    public RemoteAccountImpl(AccountIntf acct, int port,
    		java.rmi.server.RMIClientSocketFactory clientFactory,
    		java.rmi.server.RMIServerSocketFactory serverFactory) throws java.rmi.RemoteException {
		super(port, clientFactory, serverFactory);
		this.acct = acct;
    }
	public void deposit(BigDecimal amt) throws Exceptions.AccountClosed, RemoteException {
		acct.deposit(amt);
	}
	public void withdraw(BigDecimal amt) throws Exceptions.AccountClosed,
			Exceptions.InsufficientAmount, RemoteException {
		acct.withdraw(amt);
	}
	public void close() throws Exceptions.AccountClosed, RemoteException {
		acct.close();
	}
	public BigDecimal getBalance() throws Exceptions.AccountClosed, RemoteException {
		return acct.getBalance();
	}
	public String getAcctNo() throws RemoteException {
		return acct.getAcctNo();
	}
	public String getStatement() throws RemoteException {
		return acct.getStatement();
	}
}
