package common;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;

public interface RemoteAccount extends Remote {
	public void deposit(BigDecimal amt) throws Exceptions.AccountClosed, RemoteException;
	public void withdraw(BigDecimal amt) throws Exceptions.AccountClosed,
		Exceptions.InsufficientAmount, RemoteException;
	public void close() throws Exceptions.AccountClosed, RemoteException;
	public BigDecimal getBalance() throws Exceptions.AccountClosed, RemoteException;
	public String getAcctNo() throws RemoteException;
	public String getStatement() throws RemoteException;
}
