/*
 * @(#) $Id: RemoteBankServer.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package server;

import java.rmi.Naming;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.server.DefaultBankPersistenceManager;

public class RemoteBankServer {
	public static void main(String args[]) {
    	// Create and install the security manager
    	// System.setSecurityManager(new RMISecurityManager());

		try {
			DefaultBankPersistenceManager bpm =
				new DefaultBankPersistenceManager(System.getProperties());
			BankIntf bank = bpm.load();
			RemoteBankImpl rbi = new RemoteBankImpl(bank);
			Naming.rebind("MyRemoteBank", rbi);
			System.out.println("RemoteBank Server ready.");
		} catch (Exception e) {
			System.out.println("Exception: " + e.getMessage());
			e.printStackTrace();
    	}
  	}
}
