/*
 * @(#) $Id: BankProxy.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.math.BigDecimal;
import java.util.Iterator;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.AccountIntf;
import common.RemoteBank;
import common.RemoteAccount;

public class BankProxy implements BankIntf {
	private RemoteBank rb;
	public BankProxy(RemoteBank rb){
		this.rb = rb;
	}
	public AccountIntf openAccount(BigDecimal initialDeposit){
		try {
			return new AccountProxy(rb.openAccount(initialDeposit));
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public void closeAccount(String acctNo) throws Exceptions.AccountNotFound,
			Exceptions.AccountClosed {
		try {
			rb.closeAccount(acctNo);
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public AccountIntf getAccount(String acctNo) throws Exceptions.AccountNotFound {
		try {
			return new AccountProxy(rb.getAccount(acctNo));
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public Iterator accounts() {
		try {
			return new IteratorProxy(rb.accounts());
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
}
