/*
 * @(#) $Id: ShowCert.java,v 1.1.1.1 2003/10/05 18:39:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.util.Iterator;
import java.util.List;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.io.FileInputStream;

public class ShowCert {
	private static void display(String str){
		System.out.println(str);
	}
	public static void printX509Cert(X509Certificate cert, String indent){
		display(indent + "Certificate:");
		display(indent + "  Data:");
		display(indent + "    Version: " + cert.getVersion());
		display(indent + "    Serial Number: " + cert.getSerialNumber());
		display(indent + "    Signature Algorithm: " + cert.getSigAlgName());
		display(indent + "    Issuer: " + cert.getIssuerX500Principal());
		display(indent + "    Validity:");
		display(indent + "      Not Before: " + cert.getNotBefore());
		display(indent + "      Not After: " + cert.getNotAfter());
		display(indent + "    Subject: " + cert.getSubjectX500Principal());
		display(indent + "    Extensions: ");

		display(indent + "      X509v3 Basic Constraints:");
		int pathLen = cert.getBasicConstraints();
		if (pathLen != -1)	// Not a CA
			display(indent + "        CA: TRUE, pathLen: " + pathLen);
		else
			display(indent + "        CA: FALSE");

		boolean[] keyUsage = cert.getKeyUsage();
		if (keyUsage != null){
			KeyUsage ku = new KeyUsage(keyUsage);
			display(indent + "      Key Usage: " + ku.getKeyUsageString());
		}

		List list = null;
		try {
			list = cert.getExtendedKeyUsage();
		} catch (CertificateParsingException cpe){ }

		if (list != null){
			display(indent + "      Extended Key Usage:");
			Iterator li = list.iterator();
			while (li.hasNext()){
				display(indent + " ");
				display(indent + (String)li.next());
			}
			display("");
		}
	}

	public static void main(String[] args) throws Exception{
		if (args.length < 1){
			display("Usage:: java ShowCert <certfile>");
			return;
		}
		String certfile = args[0];

		CertificateFactory cf = CertificateFactory.getInstance("X.509");
		FileInputStream fis = new FileInputStream(certfile);
		Certificate cert = cf.generateCertificate(fis);
		printX509Cert((X509Certificate)cert, "");
	}
}