/*
 * @(#) $Id: ShowCRL.java,v 1.1.1.1 2003/10/05 18:39:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.util.Iterator;
import java.util.Set;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.CertificateFactory;
import java.io.FileInputStream;

public class ShowCRL {
	private static void display(String str){
		System.out.println(str);
	}
	public static void printX509CRL(X509CRL crl){
		display("CRL:");
		display("  Version: " + crl.getVersion());
		display("  Signature Algorithm: " + crl.getSigAlgName());
		display("  Issuer: " + crl.getIssuerX500Principal());
		display("  This Update: " + crl.getThisUpdate());
		display("  Next Update: " + crl.getNextUpdate());

		Set revokedCerts = crl.getRevokedCertificates();
		if (revokedCerts == null)
			return;
		Iterator itr = revokedCerts.iterator();
		int index = 0;
		while (itr.hasNext()){
			printX509CRLEntry((X509CRLEntry)itr.next(), index);
			++index;
		}
	}

	public static void printX509CRLEntry(X509CRLEntry crlEntry, int index){
		display("  CRLEntry[" + index + "]:");
		display("    Serial Number: " + crlEntry.getSerialNumber());
		display("    Revocation Date: " + crlEntry.getRevocationDate());
	}

	public static void main(String[] args) throws Exception{
		if (args.length < 1){
			System.out.println("Usage:: java ShowCRL <crlfile>");
			return;
		}
		String crlfile = args[0];

		CertificateFactory cf = CertificateFactory.getInstance("X.509");
		FileInputStream fis = new FileInputStream(crlfile);
		X509CRL crl = (X509CRL)cf.generateCRL(fis);
		printX509CRL(crl);
	}
}