/*
 * @(#) $Id: SignatureTest.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.security.KeyPairGenerator;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.NoSuchAlgorithmException;
import java.security.InvalidKeyException;
import java.io.FileInputStream;
import java.io.IOException;

public class SignatureTest {
	private static byte[] sign(String datafile, PrivateKey prvKey, String sigAlg) throws
			IOException, SignatureException, NoSuchAlgorithmException, InvalidKeyException {
   		Signature sig = Signature.getInstance(sigAlg);
   		sig.initSign(prvKey);
    	FileInputStream fis = new FileInputStream(datafile);
    	byte[] dataBytes = new byte[1024];
    	int nread = fis.read(dataBytes);
    	while (nread > 0) {
			sig.update(dataBytes, 0, nread);
			nread = fis.read(dataBytes);
		};
		return sig.sign();
	}
	private static boolean verify(String datafile, PublicKey pubKey, String sigAlg, byte[] sigbytes) throws
			IOException, SignatureException, NoSuchAlgorithmException, InvalidKeyException {
   		Signature sig = Signature.getInstance(sigAlg);
   		sig.initVerify(pubKey);
    	FileInputStream fis = new FileInputStream(datafile);
    	byte[] dataBytes = new byte[1024];
    	int nread = fis.read(dataBytes);
    	while (nread > 0) {
			sig.update(dataBytes, 0, nread);
			nread = fis.read(dataBytes);
		};
		return sig.verify(sigbytes);
	}
	public static void main(String[] unused) throws Exception {
		// Generate a key-pair
		KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA");
		kpg.initialize(512); // 512 is the keysize.
		KeyPair kp = kpg.generateKeyPair();
		PublicKey pubk = kp.getPublic();
		PrivateKey prvk = kp.getPrivate();

		String datafile = "SignatureTest.java";
		byte[] sigbytes = sign(datafile, prvk, "SHAwithDSA");
		System.out.println("Signature(in hex):: " + Util.byteArray2Hex(sigbytes));

		boolean result = verify(datafile, pubk, "SHAwithDSA", sigbytes);
		System.out.println("Signature Verification Result = " + result);
	}
}