/*
 * @(#) $Id: TraderBean.java,v 1.1.1.1 2003/10/05 18:39:01 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package rba;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;
import javax.naming.Context;

public class TraderBean implements SessionBean {

  private SessionContext ctx;
  private int tradeLimit;

  private void log(String s) {
    System.out.println(s);
  }

  public void ejbActivate() {
    log("ejbActivate called");
  }

  public void ejbRemove() {
    log("ejbRemove called");
  }

  public void ejbPassivate() {
    log("ejbPassivate called");
  }

  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");
    this.ctx = ctx;

  }

  public void ejbCreate () throws CreateException {
    log("ejbCreate called");

    try {
      InitialContext ic = new InitialContext();

      Integer tl = (Integer) ic.lookup("java:/comp/env/tradeLimit");

      tradeLimit = tl.intValue();
    } catch (NamingException ne) {
      throw new CreateException("Failed to find environment value "+ne);
    }
  }

  public TradeResult buy(String stockSymbol, int shares) {
    log("Prinicpal = " + ctx.getCallerPrincipal());
    java.security.AccessControlContext acc = java.security.AccessController.getContext();
    if (acc != null){
		log("Subject = " + javax.security.auth.Subject.getSubject(acc));
	} else {
		log("acc = " + acc);
	}
    if (shares > tradeLimit) {
      log("Attempt to buy "+shares+" is greater than limit of "+tradeLimit);
      shares = tradeLimit;
    }

    log("Buying "+shares+" shares of "+stockSymbol);
    try {
      Properties h = new Properties();
      h.put(Context.INITIAL_CONTEXT_FACTORY,
        "weblogic.jndi.WLInitialContextFactory");
      h.put(Context.PROVIDER_URL, "t3://localhost:7005");
    	InitialContext ic = new InitialContext(h);
        Object home = ic.lookup("rba-HelloHome");
        HelloHome helloHome = (HelloHome)PortableRemoteObject.narrow(home, HelloHome.class);
        Hello hello = (Hello) PortableRemoteObject.narrow(helloHome.create(), Hello.class);
    	log("hello.hello(" + stockSymbol + ") = " + hello.hello(stockSymbol));
	} catch (Exception e){
		log("IC Exception:: " + e);
	}

    return new TradeResult(shares, stockSymbol);
  }
  public TradeResult sell(String stockSymbol, int shares) {

    if (shares > tradeLimit) {
      log("Attempt to sell "+shares+" is greater than limit of "+tradeLimit);
      shares = tradeLimit;
    }

    log("Selling "+shares+" shares of "+stockSymbol);

    return new TradeResult(shares, stockSymbol);
  }

}








