/*
 * @(#) $Id: Client.java,v 1.1.1.1 2003/10/05 18:39:00 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import weblogic.security.Security;

import echo.*;

public class Client {
	static private String url = null;
	static private String username = null;
	static private String password = null;



	public static void main(String[] args) throws Exception {
		System.out.println("Running Echo Client...\n");
		if (args.length == 0){
			url = "t3://localhost:7001";
		} else if (args.length == 1){
			url = args[0];
		} else if (args.length == 3){
			url = args[0];
			username = args[1];
			password = args[2];
		} else {
			System.out.println("Usage:: java client.Client [<url> [<username> <password>]]");
			return;
		}

		LoginContext loginContext = new LoginContext("Sample", new SampleCallbackHandler(username, password, url));
		loginContext.login();
		Subject subject = loginContext.getSubject();
		SampleAction sampleAction = new SampleAction(url);
		Subject.doAs(subject, sampleAction);
	}
}
