@echo off

%JAVA_HOME%\bin\javac PerfTest.java PerfTestLauncher.java
%JAVA_HOME%\bin\jar cvf pt.jar PerfTest.class
%JAVA_HOME%\bin\jar cvf ptl.jar PerfTestLauncher*.class DFCallbackHandler.class

echo Running PerfTest without SecurityManager ...
%JAVA_HOME%\bin\java %JVM_OPTS% -cp pt.jar PerfTest %*

echo ""
echo Running PerfTest with SecurityManager and policy file: pt1.policy ...
%JAVA_HOME%\bin\java %JVM_OPTS% -Djava.security.manager -Djava.security.policy=pt1.policy -cp pt.jar PerfTest %*

echo creating a fresh keystore ...
if exist test.ks del test.ks
set _DN="CN=Pankaj Kumar,OU=OVBU,O=HP,L=Santa Clara,ST=CA,C=US"
%JAVA_HOME%\bin\keytool -genkey -alias pankaj -keystore test.ks -storepass changeit -keypass changeit -dname %_DN%

echo signing the jar file ...
%JAVA_HOME%\bin\jarsigner -keystore test.ks -storepass changeit -signedjar pts.jar pt.jar pankaj

echo ""
echo Running PerfTest with SecurityManager and policy file: pt2.policy ...
%JAVA_HOME%\bin\java %JVM_OPTS% -Djava.security.manager -Djava.security.policy=pt2.policy -cp pts.jar PerfTest %*

echo ""
echo Running PerfTest with SecurityManager and policy file: pt3.policy ...
%JAVA_HOME%\bin\java %JVM_OPTS% -Djava.security.manager -Djava.security.policy=pt3.policy -Djava.security.auth.login.config=login.conf -cp pt.jar;ptl.jar PerfTestLauncher %*