/*
 * @(#) $Id: SymmetricCipherTest.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.BadPaddingException;
import java.security.SignatureException;
import java.security.NoSuchAlgorithmException;
import java.security.InvalidKeyException;
import java.security.InvalidAlgorithmParameterException;

public class SymmetricCipherTest {
	private static byte[] iv = { 0x0a, 0x01, 0x02, 0x03, 0x04, 0x0b, 0x0c, 0x0d };

	private static byte[] encrypt(byte[] inpBytes, SecretKey key, String xform) throws
			NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException,
			NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException {
   		Cipher cipher = Cipher.getInstance(xform);
   		IvParameterSpec ips = new IvParameterSpec(iv);
   		cipher.init(Cipher.ENCRYPT_MODE, key, ips);
   		return cipher.doFinal(inpBytes);
	}
	private static byte[] decrypt(byte[] inpBytes, SecretKey key, String xform) throws
			NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException,
			NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException{
   		Cipher cipher = Cipher.getInstance(xform);
   		IvParameterSpec ips = new IvParameterSpec(iv);
   		cipher.init(Cipher.DECRYPT_MODE, key, ips);
   		return cipher.doFinal(inpBytes);
	}

	public static void main(String[] unused) throws Exception {
		String xform = "DES/ECB/PKCS5Padding";
		int keysize = 56;
		// Generate a secret key
		KeyGenerator kg = KeyGenerator.getInstance("DES");
		kg.init(keysize); // 56 is the keysize. Fixed for DES
		SecretKey key = kg.generateKey();

		byte[] dataBytes = "J2EE Security for Servlets, EJBs and Web Services".getBytes();

		byte[] encBytes = encrypt(dataBytes, key, xform);
		byte[] decBytes = decrypt(encBytes, key, xform);
		boolean expected = java.util.Arrays.equals(dataBytes, decBytes);
		System.out.println("Test " + (expected ? "SUCCEEDED!" : "FAILED!"));
	}
}