/*
 * @(#) $Id: WSSVerify.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import org.w3c.dom.Document;

import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.VerifyingKeyFactory;
import com.verisign.messaging.WSSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.xpath.XPath;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;

public class WSSVerify {
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java WSSVerify <inp-file>");
			return;
		}
		String datafile = args[0];

		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";

		System.out.println("Verifying SOAP data in file \"" + datafile + "\" using trusted certs");
		System.out.println("in keystore \"" + keystore + "\" ...");

		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());

		Document doc = XmlUtility.readXML(datafile);
		TrustVerifier verifier = new X509TrustVerifier(ks);

		WSSecurity wss = new WSSecurity();
		MessageValidity[] resa = wss.verify(doc, verifier, null);

		for (int i = 0; i < resa.length; i++){
			System.out.println("result[" + i + "] = " + resa[i].isValid());
		}
	}
}