<%@ Page language="JScript" %>
<%@ Import Namespace="System" %>
<%@ Import Namespace="System.IO" %>
<HTML>
	<HEAD>
		<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" Content="JScript">
		<meta name="vs_defaultClientScript" content="JavaScript (ECMAScript)">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
		<title>JScript.NET Programming : Database Explorer</title>
	</HEAD>
	<script runat="server">
	
	function Page_Load(o:Object, sender:EventArgs) {
		
		var fileNames:String[];
		if(!IsPostBack) {
			fileNames=DirLister.DirList("\\JSNetProgramming\\data");
			var nFiles,nIndex:int;
			nFiles=fileNames.Length;
			//listDatabases.BeginUpdate();
			for(nIndex=0;nIndex<nFiles;nIndex++)
			{
				listDatabases.Items.Add(fileNames[nIndex]);
			}
			//listDatabases.EndUpdate();
			listDatabases.SelectedIndex=0;
		}
			this.btnOk.add_Click(btnOk_Click);
		
	}
	function btnOk_Click(o:Object, sender:EventArgs) {
		if(listDatabases.SelectedIndex>=0) {
			Session["dbName"]=listDatabases.Items(listDatabases.SelectedIndex).Text;
			Server.Transfer("dbx.aspx");
		}
	}
		


class DirLister
{
 
   static function DirList( dirToList:String  ) : Array
    {

	var name,dirName:String;
	var size:long;
	var d: DirectoryInfo;
	var fnIndex,j : int;
	fnIndex=0;
	j=0;
	var fileNames = new Array();
    try {
        var  dir:DirectoryInfo = new DirectoryInfo( dirToList );
        var fsi:FileSystemInfo[] = dir.GetFileSystemInfos("*.mdb");
        for(j=0;j<fsi.Length;j++  ) {
            try {
            var creationTime:DateTime = fsi[j].CreationTime;
            var subLength:int = 25;

            if (fsi[j] instanceof FileInfo)
            {
                var f :FileInfo= FileInfo(fsi[j]);

                if (f.Name.Length < subLength)
                    subLength = f.Name.Length;

				name = f.Name.Substring(0, subLength);
				fileNames[fnIndex]=name;
				fnIndex++;
				size = f.Length;

            }
            else //it must be a directory
            {
                d = DirectoryInfo(fsi[j]);

                //this if statement simply ensures that we do not shorten the name of the file too much!
                if (d.Name.Length < subLength)
                    subLength = d.Name.Length;

                dirName = d.Name.Substring(0, subLength);

                }
            } catch (ex:Exception) {} //ignore the error, and try the next item...
        }
    }
    catch (e:Exception) {
        //Console.WriteLine("--- PROCESS ENDED ---");
        //Console.WriteLine(e.Message);
        return fileNames;
    }



    return fileNames;
    }
}

	
	
	</script>
	<body style="font-family:verdana,arial,sans serif">
		<table class="top" width="100%" height="40" cellpadding="10" cellspacing="0">
			<tr>
				<td bgcolor="#000666">
					<b><font size="5" color="white">Database Explorer</b></FONT>
				</td>
			</tr>
		</table>
		<table width="100%" height="700" cellpadding="5" cellspacing="0" border="1">
			<tr>
				<td width="25%" bgcolor="#ccccff" valign="top">
					<font size="2">Niniejsza aplikacja jest demonstracj:
						<br>
						<ul>
							<li>
								korzystania z ADO.NET do odczytu metadanych bazy</li>
							<li>
								korzystania z elementu DataGrid</li>
							<li>
								moliwoci bezporedniego wprowadzania zmian w bazie danych</li>
							<li>
								technik utrzymywania danych stanu sesji</li>
						</ul>
					</font>
				</td>
				<td valign="top">
					<p>
						Wybierz z poniszej listy baz danych...
					</p>
					<br>
					<form id="WebForm2" method="post" runat="server">
						<table>
							<tr align="center">
								<td>
									<asp:ListBox id="listDatabases" runat="server" Width="327px" Height="129px"></asp:ListBox>
								</td>
							</tr>
							<tr align="center">
								<td>
									<asp:Button id="btnOk" runat="server" Width="78px" Height="28px" Text="OK"></asp:Button>
								</td>
							</tr>
						</table>
				</td>
			</tr>
		</table>
		</form>
	</body>
</HTML>
