/*********************************************************

XML Transform.js : copyright 2001, Essam Ahmed

Przykad z ksiki: 
Essam Ahmed, Programowanie w jzyku JScript.NET (2001)

Program transformuje dokument XML do formatu HTML 
w oparciu o zwarto pliku XSL.

Sposb uycia: 
XmlTransform <plik.xml> <plik.xsl> <wynik.htm>


plik.xml - nazwa przeksztacanego dokumentu XML
plik.xsl - nazwa szablonu transformacji XSLT
wynik.htm - nazwa tworzonego dokumentu HTML

XmlTransform tworzy plik HTML i otwiera go 
w przegldarce HTML.

*********************************************************/

import System;
import System.Xml.Xsl;
import System.Diagnostics;

var args:String[]=Environment.GetCommandLineArgs();
var xslt:XslTransform;

	if (args.Length != 4) {
		Console.WriteLine("xmlTransform, (c) 2001 Essam Ahmed\nTransformuje dokument XML w oparciu o XSLT\n");
		Console.WriteLine("Sposb uycia: xmlTransform [rdoXML] [rdoXSL] [wyjcie]\n\n");
		Console.WriteLine("[rdoXML]\t- rdowy plik XML");
		Console.WriteLine("[rdoXSL]\t- rdowy plik XSL");
		Console.WriteLine("[wyjcie]\t- plik wynikowy\n");
		Console.WriteLine("Program wykorzystuje dwa pliki wejciowe do utworzenia pliku wyjciowego, po czym otwiera plik wyjciowy w domylnej przegldarce.\n");
		Environment.Exit(1);
	}
	
	try {
		xslt=new XslTransform();
		xslt.Load(args[2]);
		xslt.Transform(args[1],args[3]);
	}
	catch (e:Exception)
	{
		Console.WriteLine("Wyjtek: {0}",e.Message);
		Console.WriteLine("Dane stosu:\n{0}",e.StackTrace(0));
		Environment.Exit(1);
		 
	}
	var p:Process=new Process();
	var psi:ProcessStartInfo=new ProcessStartInfo(args[3]);
	p.StartInfo=psi;
	p.Start();

