/*********************************************************

currencyConverterSrc.js : copyright 2001, Essam Ahmed

This sample is from the book JScript.NET Programming (2001)
by Essam Ahmed

*********************************************************/


import System;
import System.Drawing;
import System.ComponentModel;
import System.Windows.Forms;
import System.Diagnostics;
import System.Math;

package currencyConverterNamespace {
    
    public class currencyConverter extends System.Windows.Forms.Form {
        
        private var label1 : System.Windows.Forms.Label;
        private var label2 : System.Windows.Forms.Label;
        private var label3 : System.Windows.Forms.Label;        
        private var label4 : System.Windows.Forms.Label;
        private var label5 : System.Windows.Forms.Label;
        
        private var txtAmount : System.Windows.Forms.TextBox;
        
        private var listBox1 : System.Windows.Forms.ListBox;
        
        private var listBox2 : System.Windows.Forms.ListBox;
        
        private var btnConvert : System.Windows.Forms.Button;
        
        private var txtConverted : System.Windows.Forms.TextBox;
        
        private var components : System.ComponentModel.IContainer = null;
        
        public function currencyConverter() {
            this.InitializeComponent();
        }
        
        public static System.STAThreadAttribute() function Main() {
            System.Windows.Forms.Application.Run(new currencyConverter());
        }
        
        private function InitializeComponent() {
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
            
            this.txtAmount = new System.Windows.Forms.TextBox();
            
            this.listBox1 = new System.Windows.Forms.ListBox();
            this.listBox2 = new System.Windows.Forms.ListBox();
            this.btnConvert = new System.Windows.Forms.Button();
            this.txtConverted = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(16, 24);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(112, 23);
            this.label1.TabIndex = 0;
            this.label1.Text = "Kwota";
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(264, 168);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(48, 23);
            this.label2.TabIndex = 6;
            // 
            // label3
            // 
            this.label3.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.label3.Location = new System.Drawing.Point(256, 24);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(56, 23);
            this.label3.TabIndex = 7;
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(24, 56);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(40, 23);
            this.label4.TabIndex = 8;
            this.label4.Text = "Z:";
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(200, 56);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(32, 23);
            this.label5.TabIndex = 9;
            this.label5.Text = "Na:";

            // 
            // txtAmount
            // 
            this.txtAmount.Location = new System.Drawing.Point(152, 24);
            this.txtAmount.MaxLength = 6;
            this.txtAmount.Name = "txtAmount";
            this.txtAmount.TabIndex = 1;
            this.txtAmount.Text = "1";
            this.txtAmount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // listBox1
            // 
            this.listBox1.ItemHeight = 16;
            this.listBox1.Items.AddRange(["US Dollar - USD", "Canadian Dollar - CAD", "Euro - EUR", "Indian Rupee - INR"]);
            this.listBox1.Location = new System.Drawing.Point(24, 80);
            this.listBox1.Name = "listBox1";
            this.listBox1.Size = new System.Drawing.Size(144, 68);
            this.listBox1.TabIndex = 2;
            this.listBox1.SetSelected(0,true);
            // 
            // listBox2
            // 
            this.listBox2.ItemHeight = 16;
            this.listBox2.Items.AddRange(["US Dollar - USD", "Canadian Dollar - CAD", "Euro - EUR", "Indian Rupee - INR"]);
            this.listBox2.Location = new System.Drawing.Point(200, 80);
            this.listBox2.Name = "listBox2";
            this.listBox2.Size = new System.Drawing.Size(144, 68);
            this.listBox2.TabIndex = 3;
            this.listBox2.SetSelected(0,true);
            // 
            // btnConvert
            // 
            this.btnConvert.Location = new System.Drawing.Point(56, 168);
            this.btnConvert.Name = "btnConvert";
            this.btnConvert.TabIndex = 4;
            this.btnConvert.Text = "Oblicz";
            this.btnConvert.add_Click(doConvert);
            // 
            // txtConverted
            // 
            this.txtConverted.Location = new System.Drawing.Point(152, 168);
            this.txtConverted.Name = "txtConverted";
            this.txtConverted.ReadOnly = true;
            this.txtConverted.TabIndex = 5;
            this.txtConverted.Text = "1";
            this.txtConverted.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            // 
            // currencyConverter
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
            this.ClientSize = new System.Drawing.Size(360, 221);
            this.Controls.AddRange([this.txtConverted, this.btnConvert, this.listBox2, this.listBox1, this.txtAmount, this.label1,this.label2,this.label3,this.label4,this.label5]);
            this.Font = new System.Drawing.Font("Arial", float(9.75), System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, byte(0));
            this.MaximizeBox = false;
            this.Name = "currencyConverter";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "Przykadowy konwerter walut";
            this.ResumeLayout(false);
            this.add_Load(startup);
            this.add_Closing(catchFormClick);
        }
        private function doConvert(obj : Object, eArgs : EventArgs){
			var cFrom,cTo : curUnit;
			var currencyConverter : curCnv = new curCnv();
			
			switch(listBox1.SelectedIndex)
			{
				case 0:cFrom=new currencyUSD; break;
				case 1:cFrom=new currencyCAD; break;
				case 2:cFrom=new currencyEUR; break;
				case 3:cFrom=new currencyINR; break;
				default: cFrom=new currencyUSD; break;
			}
			
			switch(listBox2.SelectedIndex)
			{
				case 0:cTo=new currencyUSD; break;
				case 1:cTo=new currencyCAD; break;
				case 2:cTo=new currencyEUR; break;
				case 3:cTo=new currencyINR; break;
				default:cTo=new currencyUSD; break;
			}
			cFrom.amount=parseFloat(this.txtAmount.Text);
			currencyConverter.convert(cFrom,cTo)
			txtConverted.Text=new String(currencyConverter.convertedAmount);
			this.label3.Text = cFrom.curCode;
			this.label2.Text = cTo.curCode;
			
		}
		function startup(obj : Object, eArgs : EventArgs) {
			MessageBox.Show("Programowanie w jzyku JScript.NET\nEssam Ahmed\n\nProgram demonstracyjny - konwersja walut","Programowanie w jzyku JScript.NET");
		}
		
		function catchFormClick(obj : Object, eArgs : System.ComponentModel.CancelEventArgs){
			MessageBox.Show("Wszelkie pytania prosz kierowa do autora,\npod adres essam@designs2solutions.com","Programowanie w jzyku JScript.NET");
		}
		
    }


	class curUnit {
		public var curCode : String;
		public var amount : double;
	}		
	
	class currencyEUR extends curUnit {
		public function currencyEUR() {
			curCode="EUR";
			amount=0;
		}
	}
	
	class currencyCAD extends curUnit {
		public function currencyCAD() {
			curCode="CAD";
		}
	}

	class currencyUSD extends curUnit {
		public function currencyUSD() {
			curCode="USD";
			amount=0;
		}
	}
	
	class currencyINR extends curUnit {
		public function currencyINR() {
			curCode="INR";
		}
	}

  class curCnv {
    private var converted : double;
    
    // ujawniamy waciwo tylko-do-odczytu, do pobierania wartoci wynikowej
    public function get convertedAmount() : double {
      return (System.Math.Round(converted,2));
    }
  
    public function convert(cvtFrom : curUnit, cvtTo : curUnit)
    {
      var usdAmount,newAmount : double;
      // tworzymy zmienn waluty poredniej
      var usd : currencyUSD;
      // zamieniamy cvtFrom na USD
      Debug.WriteLine("Z " + cvtFrom.curCode + ": kwota = " + String(cvtFrom.amount));
      Debug.WriteLine("Na " + cvtTo.curCode + ": kwota = " + String(cvtTo.amount));
      
      usd=ConvertToUSD(cvtFrom);
      // zamieniamy USD na cvtTo
      cvtTo.amount=usd.amount;
      ConvertInto(cvtTo);
      Debug.WriteLine("kwota wynikowa=" + String(newAmount));
      // przypisujemy zmiennej skadowej
      converted=cvtTo.amount;
      return;
    }
  
    private function ConvertToUSD(amnt:curUnit) : currencyUSD
    {
      var curRatio,rto,usdAmnt,newAmnt: double;
      var usd : currencyUSD = new currencyUSD();
      switch(amnt.curCode) {
        case "CAD": rto=0.64454; break;
        case "EUR": rto=0.87610; break;
        case "INR": rto=0.02131; break;
        case "USD": rto=1.0000; break;
        default: rto=1.0000; break;
      }
      usd.amount=amnt.amount*rto;
      return usd;
    }
  
    private function ConvertInto(amnt:curUnit) : void
    {
      var curRatio,rto,usdAmnt,newAmnt: double;
      switch(amnt.curCode) {
        case "CAD": rto=1.55150; break;
        case "INR": rto=46.93000; break;
        case "EUR": rto=1.14142; break;
        case "USD": rto=1.0000; break;
        
        default: rto=1; break;
      }
      Debug.WriteLine("Zamieniamy na " + amnt.curCode);
      Debug.WriteLine("Kwota " + String(amnt.amount));
      newAmnt=amnt.amount*rto;
      amnt.amount=newAmnt;
    }
  }

}

currencyConverterNamespace.currencyConverter.Main();
