/*
   This sample demonstrates some of JScript's conditional compilation options

   Change the line @set @debugMode=1 to @set @debugMode=0 for normal behavior
   and change it back to @set @debugMode=1 for another behavior.

*/



@set @debugMode=1;

@if (@debugMode)
{ 
	WScript.Echo("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
	WScript.Echo("** DEBUG IS ON -- Debug Information:");
	WScript.Echo("** JScript version [" + @_jscript_version + "], Build [" + @_jscript_build+"]") ;
	WScript.Echo("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
}
@end


var axObjProgId;
var dictionary;

@if(@debugMode) 
axObjProgId="Scripting.Dictionary-error";


WScript.Echo("Attempting to create \""+axObjProgId+"\" Object");

try
{
	dictionary=new ActiveXObject(axObjProgId);
}
catch(e)
{

	WScript.Echo("\n\t ***Error:" +( e.number & 0xffff) + " " + e.description + "\n");
	if ((e.number & 0xffff)==429)
	{
@end
		WScript.Echo("\t * Used invalid ProgId; trying again with a valid one...\n");
		axObjProgId="Scripting.Dictionary";
		WScript.Echo("Attempting to create \""+axObjProgId+"\" Object");
		try
		{
			dictionary=new ActiveXObject(axObjProgId);
		}
		catch(innerE)
		{

			WScript.Echo("** Another error occured: " +
				(e.number&0xffff) + " - " + e.description);
			WScript.Echo("** Can\'t continue - make sure scrun.dll is installed and registered");
			WScript.Quit();
		}
@if(@debugMode) 
	}

}
@end

WScript.Echo("Ok. Adding Items...");

dictionary.Add("key1","Item One");
@if(@debugMode) WScript.Echo("Add OK."); @end
dictionary.Add("key2","Item Two");
@if(@debugMode) WScript.Echo("Add OK."); @end
dictionary.Add("key3","Item Three");
@if(@debugMode) WScript.Echo("Add OK."); @end

WScript.Echo("List of all items in the object...");
var arrayOfItems;
// extract an array of items in the dictionary...

@if(@debugMode) WScript.Echo("Attempting to convert from VBAtrray to JScript Array..."); 
try
{
@end

arrayOfItems=(new VBArray(dictionary.Items())).toArray();

@if(@debugMode) 
} catch (e) {
			WScript.Echo("** Another error occured: " +
				(e.number&0xffff) + " - " + e.description);
			WScript.Echo("** Can\'t continue");
			WScript.Quit();
}
@end
// list items in dictionary...
for(i in arrayOfItems)
@if(@debugMode)
{

  WScript.Echo("Check element " + i);
   @end
  WScript.Echo("Element " + i + ": " +arrayOfItems[i]);
@if(@debugMode) } @end;

WScript.Echo("check if Key: \"key1\" exists");
// check if key1 exists
if(dictionary.Exists("key1"))
{
  WScript.Echo("key1 exists - Item= " + dictionary.Item("key1"));
  //re-assign the key1's item
  dictionary.Item("key1")="New Item";
  WScript.Echo("key1 reassigned - Item= " + dictionary.Item("key1"));
}

WScript.Echo("Attempt to re-add key1...");
try
{
  dictionary.Add("key1","Item 4");
} 
catch(e)
{
  WScript.Echo("  ** Can\'t do that! The error is: " + e.description);
}

WScript.Echo("Removing and re-adding \"key1\"..");
dictionary.Remove("key1");
@if(@debugMode) WScript.Echo("Remove OK."); @end
dictionary.Add("key1","Item 4");
@if(@debugMode) WScript.Echo("Add OK."); @end
WScript.Echo("OK - key1 re-added : Item= " + dictionary.Item("key1"));

/**** Output:

debugMode=1.....


- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
** DEBUG IS ON -- Debug Information:
** JScript version [5.5], Build [5207]
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Attempting to create "Scripting.Dictionary-error" Object

         ***Error:429 Automation server can't create object

         * Used invalid ProgId; trying again with a valid one...

Attempting to create "Scripting.Dictionary" Object
Ok. Adding Items...
Add OK.
Add OK.
Add OK.
List of all items in the object...
Attempting to convert from VBAtrray to JScript Array...
Check element 0
Element 0: Item One
Check element 1
Element 1: Item Two
Check element 2
Element 2: Item Three
check if Key: "key1" exists
key1 exists - Item= Item One
key1 reassigned - Item= New Item
Attempt to re-add key1...
  ** Can't do that! The error is: Unknown runtime error
Removing and re-adding "key1"..
Remove OK.
Add OK.
OK - key1 re-added : Item= Item 4

***/
