/*********************************************************

fso.js : copyright 2001, Essam Ahmed

This sample is from the book JScript.NET Programming (2001)
by Essam Ahmed

*********************************************************/

function doDemo()
{


	var fso,fileObj,driveEnum,driveLetter,fileName;

	WScript.Echo("Pocztek testu; tworzenie obiektu FileSystemObject...");
	fso = new ActiveXObject("Scripting.FileSystemObject");
	WScript.Echo("Lokalizowanie pierwszego dysku twardego w systemie...");
	
	// find the first fixed drive on the system
	driveEnum=new Enumerator(fso.Drives);
	while(!driveEnum.atEnd())
	{
		WScript.Echo("\tSprawdzanie stacji ["+driveEnum.item().DriveLetter+"]");
		if(driveEnum.item().DriveType==2)  // fixed drive = type 2
			break;
		driveEnum.moveNext();
	}
	WScript.Echo("Stacja ["+driveEnum.item().DriveLetter+"] to pierwszy dysk twardy");
	driveLetter = driveEnum.item().DriveLetter;

	//generate a temporary file name...
	WScript.Echo("Uycie metody FileSystemObject.GetTempName() do utworzenia nazwy tymczasowej...");
	fileName=driveLetter + ":\\"+fso.GetTempName();

	WScript.Echo("Nazwa pliku do testw to \'"+fileName+"\'; tworzenie pliku...");

	// create a new file, overwrite if necessary, encode using ASCII
	var demoFile = fso.CreateTextFile(fileName, true,false);
	demoFile.WriteLine("JScript.NET Programming by Essam Ahmed");
	demoFile.WriteBlankLines(2);
	demoFile.WriteLine("Demo of working with the FileSystemObject object");
	demoFile.Close();
	// make sure the test file exists...
	if(!fso.FileExists(fileName))
	{
	  WScript.Echo("The file does not exist!  Demo cancelled");
	  return;
	}

	WScript.Echo("Ok - utworzono plik testowy");
	// Get file details through the File object
	fileObj=fso.GetFile(fileName);

	WScript.Echo("");
	WScript.Echo("Wielkos pliku : " + fileObj.size + " bajty");

	// look at the attributes....
	var strAttributes,originalAttributes;
	// save the file's attributes
	originalAttributes=fileObj.Attributes;
	// build a string representing the file's attributes
	strAttributes=getFileAttributes(fileObj);
	WScript.Echo("");
	WScript.Echo("Atrybuty pocztkowe:\n\t" + strAttributes);


	// change attributes (Read-Only and Hidden);
	fileObj.Attributes=3;
	strAttributes=getFileAttributes(fileObj);
	WScript.Echo("Nowe atrybuty:\n\t" + strAttributes);

	fileObj.Attributes=originalAttributes;
	strAttributes=getFileAttributes(fileObj);

	WScript.Echo("Powrt do atrybutw pocztkowych:\n\t" + strAttributes);
	
	WScript.Echo("");
	WScript.Echo("Usuwanie pliku; koniec przykadu!");

	fileObj.Delete();


}

function getFileAttributes(fileObject)
{
	var attributeString;
	attributeString="[";
	if(fileObject.Attributes & 0)
	  attributeString+="Normal ";

	if(fileObject.Attributes & 1)
	  attributeString+="ReadOnly ";
	if(fileObject.Attributes & 2)
	  attributeString+="Hidden ";
	if(fileObject.Attributes & 4)
	  attributeString+="System ";
	if(fileObject.Attributes & 8)
	  attributeString+="Volume ";
	if(fileObject.Attributes & 16)
	  attributeString+="Directory ";
	if(fileObject.Attributes & 32)
	  attributeString+="Archive ";
	if(fileObject.Attributes & 64)
	  attributeString+="Alias ";
	if(fileObject.Attributes & 128)
	  attributeString+="Compressed ";
	return ((attributeString.substr(0,attributeString.length-1)+"]").replace(/(\s)/,","));
	/* Here's the equivalent code:
	   
       // this is a regular expression representing a whitespace character
	   var re = /(\s)/
	   var tempString;
	   // remove the last character from attributeString (a trailing space)
	   tempString=attributeString.substr(0,attributeString.length-1)
	   // add a closing bracket
	   tempString+="]"
	   // replace the spaces in the string with commas
	   tempString.replace(re,",");

       return tempString;
  */
}

doDemo();
