package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import java.math.*;
import coreservlets.*;

/** Generuje N-cyfrow, losow liczb pierwsz (domylnie
 *  N = 50). Jest to klasa potomna klasy SimplePrimeTag,
 *  w ktrej zostaa dodana obsuga atrybutu umoliwiajcego
 *  okrelanie dugoci generowanych liczb pierwszych.
 *  Metoda doStartTag klasy bazowej ju uywa zmiennej
 *  instancyjnej len, na podstawie ktrej okrelana jest
 *  przybliona dugo liczby pierwszej.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class PrimeTag extends SimplePrimeTag {
  public void setLength(String length) {
    try {
      len = Integer.parseInt(length);
    } catch(NumberFormatException nfe) {
      len = 50;
    }
  }
}
