package coreservlets;

import java.util.*;

/** Klasa implementujca koszyk - jest to struktura danych
 *  suca do przechowywania informacji o zamawianych 
 *  towarach. 
 *  Servlet OrderPage kojarzy jeden z tych koszykw z 
 *  kad sesj.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */
 
public class ShoppingCart {
  private Vector itemsOrdered;

  /** Tworz pusty koszyk */
  
  public ShoppingCart() {
    itemsOrdered = new Vector();
  }

  /** Zwraca Vector obiektw ItemOrder zawierajacych 
   *  informacje o zamwionych towarach i ich iloci.
   */
  
  public Vector getItemsOrdered() {
    return(itemsOrdered);
  }

  /** Przeglda koszyk i sprawdza czy znajduje si ju w 
   *  nim zamwienie dotyczce towary o podanym 
   *  identyfikatorze. Jeli takie zamwienie zostanie odnalezione
   *  to ilo egzemplarzy danego towaru jest inkrementowana.
   *  Jeli nie ma zamwienie dotyczcego podanego towaru,
   *  to metoda pobiera z katalogu (Catalog) informacje o nim
   *  i dodaje do koszyka odpowiedni obiekt.
   */
  
  public synchronized void addItem(String itemID) {
    ItemOrder order;
    for(int i=0; i<itemsOrdered.size(); i++) {
      order = (ItemOrder)itemsOrdered.elementAt(i);
      if (order.getItemID().equals(itemID)) {
        order.incrementNumItems();
        return;
      }
    }
    ItemOrder newOrder = new ItemOrder(Catalog.getItem(itemID));
    itemsOrdered.addElement(newOrder);
  }

  /** Przeglda koszyk w poszukiwaniu wpisu dotyczcego 
   *  towaru o podany identyfikatorze. Jeli podana liczba
   *  jest wiksza od zera to zostaje ona uyta do okrelenia
   *  iloci zamwionych egzemplarzy danego towaru. Jeli 
   *  przekazana liczba ma warto 0 (lub mniejsz od zera,
   *  co moe nastpi w przyadku bdu uytkownika) to 
   *  wpis reprezentujcy dany towar jest usuwany z koszyka.
   */
  
  public synchronized void setNumOrdered(String itemID,
                                         int numOrdered) {
    ItemOrder order;
    for(int i=0; i<itemsOrdered.size(); i++) {
      order = (ItemOrder)itemsOrdered.elementAt(i);
      if (order.getItemID().equals(itemID)) {
        if (numOrdered <= 0) {
          itemsOrdered.removeElementAt(i);
        } else {
          order.setNumItems(numOrdered);
        }
        return;
      }
    }
    ItemOrder newOrder =
      new ItemOrder(Catalog.getItem(itemID));
    itemsOrdered.addElement(newOrder);
  }
}
    
