package coreservlets;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** Applet stanowicy interfejs uytkownika umoliwiajcy
 *	korzystanie z klasy ShadowedTextFrame. Wymaga pakietu
 *	Swing oraz Java 2D.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ShadowedTextApplet extends JApplet
                                implements ActionListener {
  private JTextField messageField;
  private JComboBox fontBox;
  private JSlider fontSizeSlider;
  private JButton showFrameButton;
  
  public void init() {
    WindowUtilities.setNativeLookAndFeel();
    Color bgColor = new Color(0xFD, 0xF5, 0xE6);
    Font font = new Font("Serif", Font.PLAIN, 16);
    Container contentPane = getContentPane();
    contentPane.setLayout(new GridLayout(4, 1));
    contentPane.setBackground(bgColor);

		// Uyj pola JTextField do pobrania tesktu komunikatu.
		// Jeli w stronie JSP zosta zdefiniowany parametr 
		// MESSAGE to uyj jego wartoci jako domylnej zawartoci
		// pola.
    messageField = new JTextField(20);
    String message = getParameter("MESSAGE");
    if (message != null) {
      messageField.setText(message);
    }
    JPanel messagePanel =
      new LabelPanel("Komunikat:", "Wywietl komunikat",
                     bgColor, font, messageField);
    contentPane.add(messagePanel);

		// Uyj pola JComboBox aby umoliwi uytkownikom
		// wybr jednej z czcionek zainstalowanych w ich systemie.
    GraphicsEnvironment env =
      GraphicsEnvironment.getLocalGraphicsEnvironment();
    String[] fontNames = env.getAvailableFontFamilyNames();
    fontBox = new JComboBox(fontNames);
    fontBox.setEditable(false);
    JPanel fontPanel =
      new LabelPanel("Czcionka:", "Uyj czcionki",
                     bgColor, font, fontBox);
    contentPane.add(fontPanel);

		// Uyj suwaka (JSlider) do okrelenia wielkoci czcionki.
    fontSizeSlider = new JSlider(0, 150);
    fontSizeSlider.setBackground(bgColor);
    fontSizeSlider.setMajorTickSpacing(50);
    fontSizeSlider.setMinorTickSpacing(25);
    fontSizeSlider.setPaintTicks(true);
    fontSizeSlider.setPaintLabels(true);
    JPanel fontSizePanel =
      new LabelPanel("Wielko czcionki:", "Uyj czcionki o wielkoci",
                     bgColor, font, fontSizeSlider);
    contentPane.add(fontSizePanel);

		// Nacinicie tego przycisku spowoduje otworzenie okna
		// i wywietlenie w nim tekstu z cieniem.
    showFrameButton = new JButton("Wywietl okno");
    showFrameButton.addActionListener(this);
    JPanel buttonPanel =
      new LabelPanel("Poka tekst z cieniem:",
                     "Otwrz JFrame aby pokaza tekst z cieniem",
                     bgColor, font, showFrameButton);
    contentPane.add(buttonPanel);
  }

  public void actionPerformed(ActionEvent event) {
    String message = messageField.getText();
    if (message.length() == 0) {
      message = "Brak komunikatu!";
    }
    String fontName = (String)fontBox.getSelectedItem();
    int fontSize = fontSizeSlider.getValue();
    JFrame frame = new JFrame("Tekst z cieniem");
    JPanel panel =
      new ShadowedTextFrame(message, fontName, fontSize);
    frame.setContentPane(panel);
    frame.pack();
    frame.setVisible(true);
  }
}
