package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.awt.*;

/** Serwlet generujcy obrazy GIF zawierajce podany
 *  komunikat oraz jego cie.
 *  <P>
 *  <B>Dziaa wycznie w mechanizmach obsugi serwletw
 *  korzystajcych z platformy Java 2, gdy do rysowania
 *  obrazw uywana jest technologia Java2D.</B>
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ShadowedText extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String message = request.getParameter("message");
    if ((message == null) || (message.length() == 0)) {
      message = "Brak parametru 'message'";
    }
    String fontName = request.getParameter("fontName");
    if (fontName == null) {
      fontName = "Serif";
    }
    String fontSizeString = request.getParameter("fontSize");
    int fontSize;
    try {
      fontSize = Integer.parseInt(fontSizeString);
    } catch(NumberFormatException nfe) {
      fontSize = 90;
    }
    response.setContentType("image/gif");
    OutputStream out = response.getOutputStream();
    Image messageImage =
      MessageImage.makeMessageImage(message,
                                    fontName,
                                    fontSize);
    MessageImage.sendAsGIF(messageImage, out);
  }

  /** Formularz moe przesya dane metodami GET lub POST. */
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
