package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Servlet tworzy sze cookies: poowa z nich bdzie
 *  istnie tylko do koca aktualnej sesji (niezalenie
 *  od czasu jej trwania), a druga poowa bdzie istnie
 *  dokadnie przez godzin od czasu utworzenia 
 *  (niezalenie od tego czy przegldarka zostanie 
 *  zamknita i ponownie uruchomiona, czy nie).
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SetCookies extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    for(int i=0; i<3; i++) {
      // Domylna warto maxAge wynosi -1, co oznacza
      // e cookie bdzie istniao wycznie w czasie
      // trwania biecej sesji przegldarki.
      Cookie cookie = new Cookie("Sesyjne-Cookie-" + i,
                                 "Cookie-Warto-S" + i);
      response.addCookie(cookie);
      cookie = new Cookie("Trwale-Cookie-" + i,
                          "Cookie-Warto-T" + i);
      // Cookie bdzie wane przez godzin, niezalenie od
      // tego czy uytkownik zamknie przegldark i j 
      // ponownie otworzy czy te nie.
      cookie.setMaxAge(3600);
      response.addCookie(cookie);
    } 
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Tworzenie cookies";
    out.println
      (ServletUtilities.headWithTitle(title) +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H1 ALIGN=\"CENTER\">" + title + "</H1>\n" +
       "Ta strona tworzy sze rnych cookies.\n" +
       "Aby wywietli informacje o nich, odwied \n" +
       "<A HREF=\"/servlet/coreservlets.ShowCookies\">\n" +
       "serwlet <CODE>ShowCookies</CODE></A>.\n" +
       "<P>\n" +
       "Trzy spord utworzonych cookies s skojarzone wycznie \n" +
       "z biec sesj, natomiast pozostae trzy s trwae.\n" +
       "Teraz zamknij przegldark, uruchom j i ponownie wywietl\n" +
       "serwlet <CODE>ShowCookies</CODE>, aby sprawdzi czy \n" +
       "trzy trwae cookies s dostpne take w nowej sesji.\n" +
       "</BODY></HTML>");
  }
}
       
