package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

/** Dynamicznie generowana, zmodyfikowana wersja
 *  dokumentu HTML SearchEngines.html. Serwlet  
 *  ten uywa cookies, aby zapamita opcje 
 *  wybrane przez uytkownika.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class SearchEnginesFrontEnd extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    Cookie[] cookies = request.getCookies();
    String searchString =
      ServletUtilities.getCookieValue(cookies,
                                      "searchString",
                                      "Java Programming");
    String numResults =
      ServletUtilities.getCookieValue(cookies,
                                      "numResults",
                                      "10");
    String searchEngine =
      ServletUtilities.getCookieValue(cookies,
                                      "searchEngine",
                                      "google");
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Przeszukiwanie WWW";
    out.println
      (ServletUtilities.headWithTitle(title) +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H1 ALIGN=\"CENTER\">Przeszukiwanie WWW</H1>\n" +
       "\n" +
       "<FORM ACTION=\"/servlet/" +
         "coreservlets.CustomizedSearchEngines\">\n" +
       "<CENTER>\n" +
       "Poszukiwane wyraenie:\n" +
       "<INPUT TYPE=\"TEXT\" NAME=\"searchString\"\n" +
       "       VALUE=\"" + searchString + "\"><BR>\n" +
       "Ilo wynikw wywietlanych na stronie:\n" +
       "<INPUT TYPE=\"TEXT\" NAME=\"numResults\"\n" + 
       "       VALUE=" + numResults + " SIZE=3><BR>\n" +
       "<INPUT TYPE=\"RADIO\" NAME=\"searchEngine\"\n" +
       "       VALUE=\"google\"" +
       checked("google", searchEngine) + ">\n" +
       "Google |\n" +
       "<INPUT TYPE=\"RADIO\" NAME=\"searchEngine\"\n" +
                "       VALUE=\"infoseek\"" +
       checked("infoseek", searchEngine) + ">\n" +
       "Infoseek |\n" +
       "<INPUT TYPE=\"RADIO\" NAME=\"searchEngine\"\n" +
       "       VALUE=\"lycos\"" +
       checked("lycos", searchEngine) + ">\n" +
       "Lycos |\n" +
       "<INPUT TYPE=\"RADIO\" NAME=\"searchEngine\"\n" +
       "       VALUE=\"hotbot\"" +
       checked("hotbot", searchEngine) + ">\n" +
       "HotBot\n" +
       "<BR>\n" +
       "<INPUT TYPE=\"SUBMIT\" VALUE=\"Szukaj\">\n" +
       "</CENTER>\n" +
       "</FORM>\n" +
       "\n" +
       "</BODY>\n" +
       "</HTML>\n");
  }

  private String checked(String name1, String name2) {
    if (name1.equals(name2))
      return(" CHECKED");
    else
      return("");
  }
}
