package coreservlets;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

/** Interaktywna przegldarka wynikw zapyta. Nawizuje poczenie
 *  z podan baz danych Oracle lub Sybase, wykonuje zapytanie,
 *  i przedstawia uzyskane wyniki w formie tabeli JTable.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class QueryViewer extends JFrame
                         implements ActionListener{
  public static void main(String[] args) {
    new QueryViewer();
  }

  private JTextField hostField, dbNameField,
                     queryField, usernameField;
  private JRadioButton oracleButton, sybaseButton;
  private JPasswordField passwordField;
  private JButton showResultsButton;
  private Container contentPane;
  private JPanel tablePanel;
  
  public QueryViewer () {
    super("Przegldarka wynikw zapyta");
    WindowUtilities.setNativeLookAndFeel();
    addWindowListener(new ExitListener());
    contentPane = getContentPane();
    contentPane.add(makeControlPanel(), BorderLayout.NORTH);
    pack();
    setVisible(true);
  }

  /** Po naciniciu przycisku "Poka wyniki" lub klawisza
   *  RETURN gdy miejsce wprowadzania znajduje si w polu 
   *  tekstowym sucym do podawania zapyta, zapytanie jest
   *  wykonywane, a jego wyniki zostaj zapisane w tabeli JTable.
   *  Nastpnie wielko okna programu jest modyfikowana, tak 
   *  aby mona w nim byo wywietli tabel z wynikami.
   */
  
  public void actionPerformed(ActionEvent event) {
    String host = hostField.getText();
    String dbName = dbNameField.getText();
    String username = usernameField.getText();
    String password =
      String.valueOf(passwordField.getPassword());
    String query = queryField.getText();
    int vendor;
    if (oracleButton.isSelected()) {
      vendor = DriverUtilities.ORACLE;
    } else {
      vendor = DriverUtilities.SYBASE;
    }
    if (tablePanel != null) {
      contentPane.remove(tablePanel);
    }
    tablePanel = makeTablePanel(host, dbName, vendor,
                                username, password,
                                query);
    contentPane.add(tablePanel, BorderLayout.CENTER);
    pack();
  }

  // Wykonuje zapytanie i umieszcza wyniki w tabeli 
  // JTable, ktra z kolei jest wywietlana w panelu JPanel.
  
  private JPanel makeTablePanel(String host,
                                String dbName,
                                int vendor,
                                String username,
                                String password,
                                String query) {
    String driver = DriverUtilities.getDriver(vendor);
    String url = DriverUtilities.makeURL(host, dbName, vendor);
    DBResults results =
      DatabaseUtilities.getQueryResults(driver, url,
                                        username, password,
                                        query, true);
                                        
    JPanel panel = new JPanel(new BorderLayout());
    if (results == null) {
      panel.add(makeErrorLabel());
      return(panel);
    }
    DBResultsTableModel model =
      new DBResultsTableModel(results);
    JTable table = new JTable(model);
    table.setFont(new Font("Serif", Font.PLAIN, 17));
    table.setRowHeight(28);
    JTableHeader header = table.getTableHeader();
    header.setFont(new Font("SansSerif", Font.BOLD, 13));
    panel.add(table, BorderLayout.CENTER);
    panel.add(header, BorderLayout.NORTH);
    panel.setBorder
      (BorderFactory.createTitledBorder("Wyniki zapytania"));
    return(panel);
  }

  // Panel zawierajcy pola tekstowe, pola wyboru oraz przycisk 
  
  private JPanel makeControlPanel() {
    JPanel panel = new JPanel(new GridLayout(0, 1));
    panel.add(makeHostPanel());
    panel.add(makeUsernamePanel());
    panel.add(makeQueryPanel());
    panel.add(makeButtonPanel());
    panel.setBorder
      (BorderFactory.createTitledBorder("Wyniki"));
    return(panel);
  }

  // Panel zawierajcy pola tekstowe okrelajce komputer oraz nazw
  // bazy danych, oraz przycisk opcji sucy okrelenia uywanego 
  // sterownika. Umieszczany w panelu kontrolnym.
  
  private JPanel makeHostPanel() {
    JPanel panel = new JPanel();
    panel.add(new JLabel("Host:"));
    hostField = new JTextField(15);
    panel.add(hostField);
    panel.add(new JLabel("    Nazwa bazy:"));
    dbNameField = new JTextField(15);
    panel.add(dbNameField);
    panel.add(new JLabel("    Sterownik:"));
    ButtonGroup vendorGroup = new ButtonGroup();
    oracleButton = new JRadioButton("Oracle", true);
    vendorGroup.add(oracleButton);
    panel.add(oracleButton);
    sybaseButton = new JRadioButton("Sybase");
    vendorGroup.add(sybaseButton);
    panel.add(sybaseButton);
    return(panel);
  }

  // Panel zawierajcy pola tekstowe suce do okrelenia nazwy 
  // uytkownika oraz hasa. Wywietlany na panelu kontrolnym.
  
  private JPanel makeUsernamePanel() {
    JPanel panel = new JPanel();
    usernameField = new JTextField(10);
    passwordField = new JPasswordField(10);
    panel.add(new JLabel("Uytkownik: "));
    panel.add(usernameField);
    panel.add(new JLabel("    Haso:"));
    panel.add(passwordField);
    return(panel);
  }

  // Panel zawierajcy pole tekstowe suce do podawania zapyta.
  // Wywietlany na panelu sterujcym.
  
  private JPanel makeQueryPanel() {
    JPanel panel = new JPanel();
    queryField = new JTextField(40);
    queryField.addActionListener(this);
    panel.add(new JLabel("Zapytanie:"));
    panel.add(queryField);
    return(panel);
  }

  // Panel zawierajcy przycisk "Poka wyniki".
  // Wywietlany na panelu sterujcym.
  
  private JPanel makeButtonPanel() {
    JPanel panel = new JPanel();
    showResultsButton = new JButton("Poka wyniki");
    showResultsButton.addActionListener(this);
    panel.add(showResultsButton);
    return(panel);
  }

  // Wywietla ostrzeenie w przypadku podania bdnego zapytania.
  
  private JLabel makeErrorLabel() {
    JLabel label = new JLabel("Brak wynikw", JLabel.CENTER);
    label.setFont(new Font("Serif", Font.BOLD, 36));
    return(label);
  }
}
