package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Servlet obsuguje dania generacji strony zawierajcej n
 *  liczb pierwszych, z ktrych kada ma m cyfr.
 *  Obliczenia wykonywane s przez wtek o niskim priorytecie
 *  zwracajcy wycznie obliczenia ktre w danej chwili
 *  zostay ju zakoczone. Jeli wyniki nie s kompletne, 
 *  servlet generuje nagwek odpowiedzi Refresh, informujc
 *  przegldark, e naley powtrnie zada wynikw po 
 *  pewnym czasie. Servlet przechowuje take krtk list
 *  ostatnio wygenerowanych liczb pierwszych, ktre zwraca 
 *  od razu jeli tylko kto poda takie same parametry n i m
 *  jakie byy wykorzystane w jednym z ostatnio zakoczonych 
 *  oblicze.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class PrimeNumbers extends HttpServlet {
  private Vector primeListVector = new Vector();
  private int maxPrimeLists = 30;
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    int numPrimes =
      ServletUtilities.getIntParameter(request,
                                       "numPrimes", 50);
    int numDigits =
      ServletUtilities.getIntParameter(request,
                                       "numDigits", 120);
    PrimeList primeList =
      findPrimeList(primeListVector, numPrimes, numDigits);
    if (primeList == null) {
      primeList = new PrimeList(numPrimes, numDigits, true);
      // Wiele da to tego servletu wsplnie uywa tych
      // samych zmiennych instancyjnych (pola) klasy PrimeNumbers.
      // Dlatego trzeba synchronizowa wszystkie prby dostpu do
      // pl servletu.
      synchronized(primeListVector) {
        if (primeListVector.size() >= maxPrimeLists)
          primeListVector.removeElementAt(0);
        primeListVector.addElement(primeList);
      }
    }
    Vector currentPrimes = primeList.getPrimes();
    int numCurrentPrimes = currentPrimes.size();
    int numPrimesRemaining = (numPrimes - numCurrentPrimes);
    boolean isLastResult = (numPrimesRemaining == 0);
    if (!isLastResult) {
      response.setHeader("Refresh", "5");
    }
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Kilka " + numDigits + "-cyfrowych liczb pierwszych";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H2 ALIGN=CENTER>" + title + "</H2>\n" +
                "<H3>Odnalezione liczby pierwsze o dugoci " + numDigits +
                " cyfr lub wikszej: " + numCurrentPrimes +
                ".</H3>");
    if (isLastResult)
      out.println("<B>Obliczenia zakoczone.</B>");
    else
      out.println("<B>Cigle szukam " + numPrimesRemaining +
                  " pozostaych liczb<BLINK>...</BLINK></B>");
    out.println("<OL>");
    for(int i=0; i<numCurrentPrimes; i++) {
      out.println("  <LI>" + currentPrimes.elementAt(i));
    }
    out.println("</OL>");
    out.println("</BODY></HTML>");
  }

  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }

  /* Metoda sprawdza czy istniej jaka aktualnie obliczana
   * lub ju obliczona lista liczb pierwszych o podaje iloci 
   * liczb oraz iloci cyfr w liczbie. Jeli taka lista 
   * istnieje to zwraca t list zamiast uruchamiania nowego
   * wtku obliczeniowego dziaajcego w tle. Lista wynikw
   * powinna by moliwie niewielka, aby nie zabieraa zbyt 
   * duo pamici na serwerze. Dostp do tej listy naley
   * synchronizowa, gdy jednoczenie moe si do niej 
   * odwoywa wiele wtkw.
   */
  
  private PrimeList findPrimeList(Vector primeListVector,
                                  int numPrimes,
                                  int numDigits) {
    synchronized(primeListVector) {
      for(int i=0; i<primeListVector.size(); i++) {
        PrimeList primes =
          (PrimeList)primeListVector.elementAt(i);
        if ((numPrimes == primes.numPrimes()) &&
            (numDigits == primes.numDigits()))
          return(primes);
      }
      return(null);
    }
  }
}
