package coreservlets;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import Acme.JPM.Encoders.GifEncoder;

/** Narzdzia suce do tworzenia obrazw prezentujcych
 *  komunikat wraz z cieniem. Zawiera metody wykorzystujce
 *  GifEncoder Jefa Poskanzera (do generacji obrazu w formacie 
 *  GIF).
 *  <P>
 *  <B>Nie dziaa w JDK 1.1, gdy do tworzenia obrazw
 *  uywana jest technologia Java2D.</B>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class MessageImage {
  
  /** Tworzy Image (obraz) przedstawiajcy komunikat
   *  oraz jego cie. Uywany przez servlet ShadowedText
   *  oraz aplikacj ShadowedTextFrame.
   */

  public static Image makeMessageImage(String message,
                                       String fontName,
                                       int fontSize) {
    Frame f = new Frame();
    // Pocz z rodzimymi zasobami aby utworzy obraz.
    f.addNotify();
    // Upewnij si, e Java zna nazwy lokalnych czcionek.
    GraphicsEnvironment env = 
      GraphicsEnvironment.getLocalGraphicsEnvironment();
    env.getAvailableFontFamilyNames(); 
    Font font = new Font(fontName, Font.PLAIN, fontSize);
    FontMetrics metrics = f.getFontMetrics(font);
    int messageWidth = metrics.stringWidth(message);
    int baselineX = messageWidth/10;
    int width = messageWidth+2*(baselineX + fontSize);
    int height = fontSize*7/2;
    int baselineY = height*8/10;
    Image messageImage = f.createImage(width, height);
    Graphics2D g2d =
      (Graphics2D)messageImage.getGraphics();
    g2d.setFont(font);
    g2d.translate(baselineX, baselineY);
    g2d.setPaint(Color.lightGray);
    AffineTransform origTransform = g2d.getTransform();
    g2d.shear(-0.95, 0);
    g2d.scale(1, 3);
    g2d.drawString(message, 0, 0);
    g2d.setTransform(origTransform);
    g2d.setPaint(Color.black);
    g2d.drawString(message, 0, 0);
    return(messageImage);
  }

  /** Korzysta z klasy GifEncoder w celu przesania obrazu
   *  (zawartoci obiektu Image) w formacie GIF89A 
   *  do strumienia wyjciowego. Klas GifEncoder mona
   *  znale pod adresem http://www.acme.com/java.
   */
  
  public static void sendAsGIF(Image image, OutputStream out) {
    try {
      new GifEncoder(image, out).encode();
    } catch(IOException ioe) {
      System.err.println("Bd przy przesyaniu obrazu GIF: " + ioe);
    }
  }
}
