package coreservlets;

import java.sql.*;

/** Przykad uycia JDBC, ktry nawizuje poczenie 
 *  z baz Oracle lub Sybase i wywietla wartoci 
 *  z gry okrelonych kolumn tabeli "fruits".
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class FruitTest {

  /** Odczytuje nazw komputera, bazy danych, uytkownika, 
   *  haso dostpu oraz dostawcy z wiersza polece.
   *  Identyfikator dostawcy jest uywany w celu okrelenia
   *  jaki sterownik naley zaadowa oraz jak sformatowa
   *  adres URL. Sterownik, adres URL, nazwa komputera,
   *  nazwa uytkownika oraz haso s nastpnie 
   *  przekazywane do metody showFruitTable.
   */
  
  public static void main(String[] args) {
    if (args.length < 5) {
      printUsage();
      return;
    }
    String vendorName = args[4];
    int vendor = DriverUtilities.getVendor(vendorName);
    if (vendor == DriverUtilities.UNKNOWN) {
      printUsage();
      return;
    }
    String driver = DriverUtilities.getDriver(vendor);
    String host = args[0];
    String dbName = args[1];
    String url = DriverUtilities.makeURL(host, dbName, vendor);
    String username = args[2];
    String password = args[3];
    showFruitTable(driver, url, username, password);
  }

  /** Pobiera tabel i wywietla ca jej zawarto. */
  
  public static void showFruitTable(String driver,
                                    String url,
                                    String username,
                                    String password) {
    try {
      // Zaaduj sterownik bazy danych, jeli jeszcze nie jest to zrobione.
      Class.forName(driver);
      // Nawi poczenie sieciowe z baz danych.
      Connection connection =
        DriverManager.getConnection(url, username, password);
      // Pobierz informacje dotyczce samej bazy danych.
      DatabaseMetaData dbMetaData = connection.getMetaData();
      String productName =
        dbMetaData.getDatabaseProductName();
      System.out.println("Baza danych: " + productName);
      String productVersion =
        dbMetaData.getDatabaseProductVersion();
      System.out.println("Wersja: " + productVersion + "\n");
      System.out.println("Porwnanie jabek i pomaraczy\n" +
                         "============================");
      Statement statement = connection.createStatement();
      String query = "SELECT * FROM fruits";
      // Wylij zapytanie do bazy danych i zapisz wyniki.
      ResultSet resultSet = statement.executeQuery(query);
      // Pobierz informacje dotyczce konkretnej tabeli.
      ResultSetMetaData resultsMetaData =
        resultSet.getMetaData();
      int columnCount = resultsMetaData.getColumnCount();
      // Indeksy kolumn s liczone od 1 (jak w SQLu) a nie 
      // od 0 (jak w jzyku Java).
      for(int i=1; i<columnCount+1; i++) {
        System.out.print(resultsMetaData.getColumnName(i) +
                         "  ");
      }
      System.out.println();
      // Wywietl wyniki.
      while(resultSet.next()) {
        // Kwarta
        System.out.print("    " + resultSet.getInt(1));
        // Ilo jabek
        System.out.print("     " + resultSet.getInt(2));
        // Sprzeda jabek
        System.out.print("   $" + resultSet.getFloat(3));
        // Ilo pomaraczy
        System.out.print("    " + resultSet.getInt(4));
        // Sprzeda pomaraczy
        System.out.print("    $" + resultSet.getFloat(5));
        // Najlepszy sprzedawca
        System.out.println("      " + resultSet.getString(6));
      }
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Bd adowania sterownika: " + cnfe);
    } catch(SQLException sqle) {
      System.err.println("Bd przy nawizywaniu poczenia: " + sqle);
    }
  }

  private static void printUsage() {
    System.out.println("Uycie: FruitTest komputer nazwaBazyDanych " +
                       "nazwaUytkownika haso oracle|sybase.");
  }
}
