package coreservlets;

import java.sql.*;
import java.util.*;

/** Klasa suca do przechowywania penych wynikw zwrconych 
 *  zapytanie SQL. Klasa ta rni si od klasy ResultSet pod
 *  kilkoma wzgldami:
 *  <UL>
 *    <LI>ResultSet nie koniecznie zawiera wszystkie informacje;
 *        w przypadku prby pobrania dalszych wierszy wynikw, 
 *        nastpuje ponowne poczenie i pobranie wynikw z bazy
 *        danych.
 *    <LI>Ta klasa przechowuje wyniki w tablicach, w formie 
 *        acuchw znakw.
 *    <LI>Ta klasa zawiera informacje przechowywany w DatabaseMetaData 
 *        (nazw oprogramowania serwera bazy danych i numer wersji) 
 *        oraz ResultSetMetaData (nazwy kolumn).
 *    <LI>Ta klasa udostpnia metod toHTMLTable ktra zwraca 
 *        wszystkie informacje przedstawione w formie jednego 
 *        dugiego acucha znakw zawierajcego tabel HTML.
 *  </UL>
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class DBResults {
  private Connection connection;
  private String productName;
  private String productVersion;
  private int columnCount;
  private String[] columnNames;
  private Vector queryResults;
  String[] rowData;

  public DBResults(Connection connection,
                   String productName,
                   String productVersion,
                   int columnCount,
                   String[] columnNames) {
    this.connection = connection;
    this.productName = productName;
    this.productVersion = productVersion;
    this.columnCount = columnCount;
    this.columnNames = columnNames;
    rowData = new String[columnCount];
    queryResults = new Vector();
  }

  public Connection getConnection() {
    return(connection);
  }
  
  public String getProductName() {
    return(productName);
  }

  public String getProductVersion() {
    return(productVersion);
  }

  public int getColumnCount() {
    return(columnCount);
  }

  public String[] getColumnNames() {
    return(columnNames);
  }

  public int getRowCount() {
    return(queryResults.size());
  }

  public String[] getRow(int index) {
    return((String[])queryResults.elementAt(index));
  }

  public void addRow(String[] row) {
    queryResults.addElement(row);
  }

  /** Wywietl wyniki w formie tabeli HTML, w ktrej 
   *  nagwkami s nazwy kolumn, a pozostae dane
   *  s zapisane w zwyczajnych komrkach tabeli.
   */
  
  public String toHTMLTable(String headingColor) {
    StringBuffer buffer =
      new StringBuffer("<TABLE BORDER=1>\n");
    if (headingColor != null) {
      buffer.append("  <TR BGCOLOR=\"" + headingColor +
                    "\">\n    ");
    } else {
      buffer.append("  <TR>\n    ");
    }
    for(int col=0; col<getColumnCount(); col++) {
      buffer.append("<TH>" + columnNames[col]);
    }
    for(int row=0; row<getRowCount(); row++) {
      buffer.append("\n  <TR>\n    ");
      String[] rowData = getRow(row);
      for(int col=0; col<getColumnCount(); col++) {
        buffer.append("<TD>" + rowData[col]);
      }
    }
    buffer.append("\n</TABLE>");
    return(buffer.toString());
  } 
}
    
  
