package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.*;

/** Zmodyfikowana wersja serwletu SearchEngine, ktra
 *  wykorzystuje cookies w celu zapamitania opcji 
 *  wybranych przez uytkownika. Zapamitane wartoci
 *  s nastpnie wykorzystywane przez serwlet
 *  SearchEngineFrontEnd w celu inicjalizacji pl
 *  formularza wyszukiwawczego.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class CustomizedSearchEngines extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    
    String searchString = request.getParameter("searchString");
    if ((searchString == null) ||
        (searchString.length() == 0)) {
      reportProblem(response, "Brak acucha zapytania.");
      return;
    }
    Cookie searchStringCookie =
      new LongLivedCookie("searchString", searchString);
    response.addCookie(searchStringCookie);
    // Klasa URLEncoder zamienia odstpy na znaki "+"
    // oraz inne znaki ktre nie s znakami alfanumerycznymi
    // na wyraenia %XY, gdzie XY to warto znaku w kodzie
    // ASCII (lub ISO Latin-1) zapisana w formie liczby 
    // szesnastkowej.
    // Przegldarki zawsze koduj wartoci wpisane w polach
    // formularzy w ten wanie sposb, a zatem metoda 
    // getParameter serwletw dekoduje je automatycznie.
    // Jednak my przekazujemy te wartoci na inny serwer,
    // i dlatego musimy je ponownie zakodowa.
    searchString = URLEncoder.encode(searchString);
    String numResults = request.getParameter("numResults");
    if ((numResults == null) ||
        (numResults.equals("0")) ||
        (numResults.length() == 0)) {
      numResults = "10";
    }
    Cookie numResultsCookie =
      new LongLivedCookie("numResults", numResults);
    response.addCookie(numResultsCookie);
    String searchEngine = request.getParameter("searchEngine");
    if (searchEngine == null) {
      reportProblem(response, "Brak nazwy serwisu wyszukiwawczego.");
      return;
    }
    Cookie searchEngineCookie =
      new LongLivedCookie("searchEngine", searchEngine);
    response.addCookie(searchEngineCookie);
    SearchSpec[] commonSpecs = SearchSpec.getCommonSpecs();
    for(int i=0; i<commonSpecs.length; i++) {
      SearchSpec searchSpec = commonSpecs[i];
      if (searchSpec.getName().equals(searchEngine)) {
        String url =
          searchSpec.makeURL(searchString, numResults);
        response.sendRedirect(url);
        return;
      }
    }
    reportProblem(response, "Nieznany mechanizm wyszukiwawczy.");
  }

  private void reportProblem(HttpServletResponse response,
                             String message)
      throws IOException {
    response.sendError(response.SC_NOT_FOUND,
                       "<H2>" + message + "</H2>");
  }
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
