package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

/** Serwlet odczytuje informacje z bazy danych i wywietla
 *  je w postaci tabeli HTML. Serwlet wykorzystuje pul
 *  pocze w celu optymalizacji pobierania danych z bazy.
 *  Doskonaym testem jest strona ConnectionPool.html, 
 *  ktra wywietla wyniki wykonania tego serwletu w 25
 *  ramkach.
 *  <P>
 *  Przykady z ksiki Java Servlet i JavaServer Pages
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2000 Marty Hall; mona kopiowa i modyfikowa bez ogranicze.
 */

public class ConnectionPoolServlet extends HttpServlet {
  private ConnectionPool connectionPool;
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String table;
    try {
      String query =
        "SELECT firstname, lastname " +
        " FROM employees WHERE salary > 70000";
      Connection connection = connectionPool.getConnection();
      DBResults results =
          DatabaseUtilities.getQueryResults(connection,
                                            query, false);
      connectionPool.free(connection);
      table = results.toHTMLTable("#FFAD00");
    } catch(Exception e) {
      table = "Bd: " + e;
    }
    response.setContentType("text/html; charset=Windows-1250");
    // Zadaj aby przegldarka nie przechowywaa wynikw 
    // w pamici podrcznej. Wicej informacji na ten temat
    // znajdziesz w podrozdziale 7.2 ksiki Java Servlet i
    // Java Server Pages.
    response.setHeader("Pragma", "no-cache"); // HTTP 1.0
    response.setHeader("Cache-Control", "no-cache"); // HTTP 1.1
    PrintWriter out = response.getWriter();
    String title = "Test wykorzystania puli pocze";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<CENTER>\n" +
                table + "\n" +
                "</CENTER>\n</BODY></HTML>");
  }

  /** Inicjalizuje pul pocze w momencie inicjowania 
   *  serwletu. Aby unikn opnie czasowych w momencie
   *  otrzymania pierwszego dania skierowanego do tego
   *  serwletu, naley go zawczasu zaadowa samemu, lub
   *  tak skonfigurowa serwera, aby serwlet by 
   *  automatycznie adowany po ponownym uruchomieniu
   *  serwera.
   */
  
  public void init() {
    int vendor = DriverUtilities.SYBASE;
    String driver = DriverUtilities.getDriver(vendor);
    String host = "128.220.101.65";
    String dbName = "605741";
    String url = DriverUtilities.makeURL(host, dbName, vendor);
    String username = "hall";
    String password = "hall";
    try {
      connectionPool =
        new ConnectionPool(driver, url, username, password,
                           initialConnections(),
                           maxConnections(),
                           true);
    } catch(SQLException sqle) {
      System.err.println("Bd tworzenia puli pocze: " + sqle);
      getServletContext().log("Bd tworzenia puli pocze: " + sqle);
      connectionPool = null;
    }
  }

  public void destroy() {
    connectionPool.closeAllConnections();
  }

  /** Przeso t metod w klasie potomnej aby zmieni 
   *  pocztkow ilo pocze.
   */
  
  protected int initialConnections() {
    return(10);
  }

  /** Przeso t metod w klasie potomnej aby zmieni 
   *  maksymaln ilo tworzonych pocze.
   */

  protected int maxConnections() {
    return(50);
  }
}
